/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.vast.ows.OWSIdentification;
import org.vast.ows.OWSLayerCapabilities;
import org.vast.ows.OWSNotificationService;
import org.vast.ows.OWSResponse;
import org.vast.util.ResponsibleParty;

public class OWSServiceCapabilities
extends OWSResponse {
    protected String updateSequence = null;
    protected OWSIdentification identification;
    protected List<String> supportedVersions;
    protected List<String> profiles;
    protected String fees;
    protected String accessConstraints;
    protected ResponsibleParty serviceProvider;
    protected OWSNotificationService notificationCapabilities;
    protected List<? extends OWSLayerCapabilities> layers;
    protected List<String> exceptionTypes;
    protected Map<String, String> getServers;
    protected Map<String, String> postServers;

    public OWSServiceCapabilities() {
        this.messageType = "Capabilities";
        this.identification = new OWSIdentification();
        this.serviceProvider = new ResponsibleParty();
        this.supportedVersions = new ArrayList<String>(1);
        this.profiles = new ArrayList<String>(5);
        this.layers = new ArrayList<OWSLayerCapabilities>(10);
        this.exceptionTypes = new ArrayList<String>(1);
        this.getServers = new LinkedHashMap<String, String>();
        this.postServers = new LinkedHashMap<String, String>();
    }

    public String getUpdateSequence() {
        return this.updateSequence;
    }

    public void setUpdateSequence(String updateSequence) {
        this.updateSequence = updateSequence;
    }

    public void increaseUpdateSequence() {
        try {
            int seq = Integer.parseInt(this.updateSequence);
            this.updateSequence = Integer.toString(++seq);
        }
        catch (Exception e) {
            this.updateSequence = "1";
        }
    }

    public OWSIdentification getIdentification() {
        return this.identification;
    }

    public void setIdentification(OWSIdentification identification) {
        this.identification = identification;
    }

    public String getFees() {
        return this.fees;
    }

    public void setFees(String fees) {
        this.fees = fees;
    }

    public String getAccessConstraints() {
        return this.accessConstraints;
    }

    public void setAccessConstraints(String accessConstraints) {
        this.accessConstraints = accessConstraints;
    }

    public List<String> getSupportedVersions() {
        return this.supportedVersions;
    }

    public List<String> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<String> profiles) {
        this.profiles = profiles;
    }

    public ResponsibleParty getServiceProvider() {
        return this.serviceProvider;
    }

    public void setServiceProvider(ResponsibleParty serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public OWSNotificationService getNotificationCapabilities() {
        return this.notificationCapabilities;
    }

    public void setNotificationCapabilities(OWSNotificationService notificationCapabilities) {
        this.notificationCapabilities = notificationCapabilities;
    }

    public Map<String, String> getGetServers() {
        return this.getServers;
    }

    public void setGetServers(Map<String, String> getServers) {
        this.getServers = getServers;
    }

    public Map<String, String> getPostServers() {
        return this.postServers;
    }

    public void setPostServers(Map<String, String> postServers) {
        this.postServers = postServers;
    }

    public List<? extends OWSLayerCapabilities> getLayers() {
        return this.layers;
    }

    public void setLayers(List<? extends OWSLayerCapabilities> layers) {
        this.layers = layers;
    }

    public OWSLayerCapabilities getLayer(String layerId) {
        for (int i = 0; i < this.layers.size(); ++i) {
            OWSLayerCapabilities nextLayer = this.layers.get(i);
            String nextId = nextLayer.getIdentifier();
            if (!nextId.equals(layerId)) continue;
            return nextLayer;
        }
        return null;
    }

    public List<String> getExceptionTypes() {
        return this.exceptionTypes;
    }

    public void setExceptionTypes(List<String> exceptionTypes) {
        this.exceptionTypes = exceptionTypes;
    }

    public String toString() {
        StringBuffer text = new StringBuffer(this.service + " Service Capabilities: ");
        text.append(this.identification.getTitle());
        String desc = this.identification.getDescription();
        if (desc != null) {
            text.append("\n");
            text.append("Description: ");
            text.append(desc);
        }
        text.append("\n");
        text.append("Layer list: \n");
        for (int i = 0; i < this.layers.size(); ++i) {
            text.append("   ");
            text.append(this.layers.get(i).toString());
            text.append("\n");
        }
        return text.toString();
    }
}

