/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vast.ogc.OGCException;
import org.vast.ogc.OGCExceptionReader;
import org.vast.ogc.OGCRegistry;
import org.vast.ows.AbstractRequestReader;
import org.vast.ows.GetCapabilitiesRequest;
import org.vast.ows.OWSCommonUtils;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReader;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.OWSExceptionWriter;
import org.vast.ows.OWSRequest;
import org.vast.ows.OWSRequestReader;
import org.vast.ows.OWSRequestWriter;
import org.vast.ows.OWSResponse;
import org.vast.ows.OWSResponseReader;
import org.vast.ows.OWSResponseWriter;
import org.vast.ows.OWSServiceCapabilities;
import org.vast.xml.DOMHelper;
import org.vast.xml.DOMHelperException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OWSUtils
extends OWSCommonUtils {
    private static final Logger log = LoggerFactory.getLogger(OWSUtils.class);
    public static final String XML_MIME_TYPE = "text/xml";
    public static final String XML_MIME_TYPE2 = "application/xml";
    public static final String JSON_MIME_TYPE = "application/json";
    public static final String OGC = "OGC";
    public static final String OWS = "OWS";
    public static final String WMS = "WMS";
    public static final String WFS = "WFS";
    public static final String WCS = "WCS";
    public static final String SWES = "SWES";
    public static final String SOS = "SOS";
    public static final String CSW = "CSW";
    public static final String WNS = "WNS";
    public static final String SAS = "SAS";
    public static final String SPS = "SPS";
    public static final String WPS = "WPS";
    public static final String SLD = "SLD";
    public static final String unsupportedSpec = "No support for ";
    public static final String invalidEndpoint = "No Endpoint URL specified in request object";
    public static final String ioError = "I/O Error while sending request: ";
    public static final String SOAP11_URI = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String SOAP12_URI = "http://www.w3.org/2003/05/soap-envelope";
    OWSCommonUtils dataTypeUtils = new OWSCommonUtils();

    public static void loadRegistry() {
        String mapFileUrl = OWSUtils.class.getResource("OWSRegistry.xml").toString();
        OGCRegistry.loadMaps((String)mapFileUrl, (boolean)false);
    }

    public static String getNamespaceURI(String spec, String version) {
        return OGCRegistry.getNamespaceURI((String)spec, (String)version);
    }

    public OWSRequest readXMLQuery(DOMHelper dom, Element requestElt, String serviceType, String defaultVersion) throws OWSException {
        OWSRequest request = new OWSRequest();
        request.setVersion(defaultVersion);
        AbstractRequestReader.readCommonXML(dom, requestElt, request);
        OWSExceptionReport report = new OWSExceptionReport();
        AbstractRequestReader.checkParameters(request, report, serviceType);
        report.process();
        try {
            OWSRequestReader reader = (OWSRequestReader)OGCRegistry.createReader((String)request.service, (String)request.operation, (String)request.version);
            request = reader.readXMLQuery(dom, requestElt);
            return request;
        }
        catch (IllegalStateException e) {
            String spec = request.service + " " + request.operation + " v" + request.version;
            throw new OWSException(unsupportedSpec + spec, e);
        }
    }

    public OWSRequest readXMLQuery(DOMHelper dom, Element requestElt, String serviceType) throws OWSException {
        return this.readXMLQuery(dom, requestElt, serviceType, null);
    }

    public OWSRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        return this.readXMLQuery(dom, requestElt, null, null);
    }

    public OWSRequest readXMLQuery(InputStream is, String serviceType) throws OWSException {
        try {
            DOMHelper dom = new DOMHelper(is, false);
            OWSRequest request = this.readXMLQuery(dom, dom.getRootElement(), serviceType);
            return request;
        }
        catch (DOMHelperException e) {
            throw new OWSException("Invalid XML Request", (Exception)((Object)e));
        }
    }

    public OWSRequest readXMLQuery(InputStream is) throws OWSException {
        return this.readXMLQuery(is, null);
    }

    public OWSRequest readURLQuery(String queryString, String serviceType, String defaultVersion) throws OWSException {
        OWSRequest request = new OWSRequest();
        try {
            Map<String, String> queryParams = this.parseQueryParameters(queryString);
            request.setService(queryParams.get("service"));
            request.setOperation(queryParams.get("request"));
            request.setVersion(queryParams.get("version"));
            if (request.getVersion() == null) {
                request.setVersion(defaultVersion);
            }
            OWSExceptionReport report = new OWSExceptionReport();
            AbstractRequestReader.checkParameters(request, report, serviceType);
            report.process();
            OWSRequestReader reader = (OWSRequestReader)OGCRegistry.createReader((String)request.service, (String)request.operation, (String)request.version);
            request = reader.readURLParameters(queryParams);
            return request;
        }
        catch (IllegalStateException e) {
            String spec = request.service + " " + request.operation + " v" + request.version;
            throw new OWSException(unsupportedSpec + spec, e);
        }
    }

    public OWSRequest readURLQuery(String queryString, String serviceType) throws OWSException {
        return this.readURLQuery(queryString, serviceType, null);
    }

    public OWSRequest readURLQuery(String queryString) throws OWSException {
        return this.readURLQuery(queryString, null);
    }

    public String readXMLVersion(DOMHelper dom, Element objectElt) throws OWSException {
        String version = dom.getAttributeValue(objectElt, "@version");
        if (version == null || version.length() == 0) {
            String nsUri = objectElt.getNamespaceURI();
            version = nsUri.substring(nsUri.lastIndexOf(47) + 1);
        }
        if (version == null || version.length() == 0) {
            throw new OWSException("Cannot figure out document version");
        }
        return version;
    }

    public String buildURLQuery(OWSRequest request) throws OWSException {
        try {
            OWSRequestWriter writer = (OWSRequestWriter)OGCRegistry.createWriter((String)request.service, (String)request.operation, (String)request.version);
            String url = writer.buildURLQuery(request);
            return url;
        }
        catch (IllegalStateException e) {
            String spec = request.service + " " + request.operation + " v" + request.version;
            throw new OWSException(unsupportedSpec + spec, e);
        }
    }

    public Element buildXMLQuery(DOMHelper dom, OWSRequest request) throws OWSException {
        try {
            OWSRequestWriter writer = (OWSRequestWriter)OGCRegistry.createWriter((String)request.service, (String)request.operation, (String)request.version);
            Element requestElt = writer.buildXMLQuery(dom, request);
            return requestElt;
        }
        catch (IllegalStateException e) {
            String spec = request.service + " " + request.operation + " v" + request.version;
            throw new OWSException(unsupportedSpec + spec, e);
        }
    }

    public void writeXMLQuery(OutputStream os, OWSRequest request) throws OWSException {
        try {
            DOMHelper dom = new DOMHelper();
            Element requestElt = this.buildXMLQuery(dom, request);
            dom.serialize((Node)requestElt, os, true);
        }
        catch (IOException e) {
            throw new OWSException("IO error while writing XML request to stream", e);
        }
    }

    public OWSResponse readXMLResponse(DOMHelper dom, Element responseElt, String serviceType) throws OWSException {
        return this.readXMLResponse(dom, responseElt, serviceType, null, null);
    }

    public OWSResponse readXMLResponse(DOMHelper dom, Element responseElt, String serviceType, String responseType) throws OWSException {
        return this.readXMLResponse(dom, responseElt, serviceType, responseType, null);
    }

    public OWSResponse readXMLResponse(DOMHelper dom, Element responseElt, String serviceType, String responseType, String version) throws OWSException {
        OWSExceptionReader.checkException(dom, responseElt);
        if (responseType == null) {
            responseType = responseElt.getLocalName();
        }
        if (version == null) {
            version = this.readXMLVersion(dom, responseElt);
        }
        try {
            OWSResponseReader reader = (OWSResponseReader)OGCRegistry.createReader((String)serviceType, (String)responseType, (String)version);
            Object response = reader.readXMLResponse(dom, responseElt);
            return response;
        }
        catch (IllegalStateException e) {
            String spec = serviceType + " " + responseType + " v" + version;
            throw new OWSException(unsupportedSpec + spec, e);
        }
    }

    public OWSResponse readXMLResponse(InputStream is, String serviceType, String responseType) throws OWSException {
        try {
            DOMHelper dom = new DOMHelper(is, false);
            OWSResponse resp = this.readXMLResponse(dom, dom.getRootElement(), serviceType, responseType);
            return resp;
        }
        catch (DOMHelperException e) {
            throw new OWSException("Invalid XML Response", (Exception)((Object)e));
        }
    }

    public Element buildXMLResponse(DOMHelper dom, OWSResponse response, String version) throws OWSException {
        try {
            OWSResponseWriter writer = (OWSResponseWriter)OGCRegistry.createWriter((String)response.service, (String)response.messageType, (String)version);
            Element requestElt = writer.buildXMLResponse(dom, response, version);
            return requestElt;
        }
        catch (IllegalStateException e) {
            String spec = response.service + " " + response.messageType + " v" + version;
            throw new OWSException(unsupportedSpec + spec, e);
        }
    }

    public Element buildXMLResponse(DOMHelper dom, OWSResponse response) throws OWSException {
        return this.buildXMLResponse(dom, response, response.getVersion());
    }

    public void writeXMLResponse(OutputStream os, OWSResponse response, String version) throws OWSException {
        this.writeXMLResponse(os, response, version, null);
    }

    public void writeXMLResponse(OutputStream os, OWSResponse response) throws OWSException {
        this.writeXMLResponse(os, response, response.getVersion());
    }

    public void writeXMLResponse(OutputStream os, OWSResponse response, String version, String soapVersion) throws OWSException {
        try {
            DOMHelper dom = new DOMHelper();
            Element responseElt = this.buildXMLResponse(dom, response, version);
            if (soapVersion != null) {
                dom.addUserPrefix("soap", soapVersion);
                Element bodyElt = dom.createElement("soap:Body");
                bodyElt.appendChild(responseElt);
                Element envElt = dom.createElement("soap:Envelope");
                envElt.appendChild(bodyElt);
                responseElt = envElt;
            }
            dom.serialize((Node)responseElt, os, true);
        }
        catch (IOException e) {
            throw new OWSException("IO error while writing XML response to stream", e);
        }
    }

    public void writeXMLException(OutputStream os, String serviceType, String version, OWSException e) {
        OWSExceptionWriter writer = new OWSExceptionWriter();
        String owsVersion = OGCRegistry.getOWSVersion((String)serviceType, (String)version);
        e.setVersion(owsVersion);
        writer.writeException(os, e);
    }

    public <ResponseType extends OWSResponse> ResponseType sendRequest(OWSRequest request, boolean useSoap) throws OWSException {
        HttpURLConnection conn = null;
        if (request.getGetServer() != null) {
            conn = this.sendGetRequest(request);
        } else if (request.getPostServer() != null) {
            conn = useSoap ? this.sendSoapRequest(request) : this.sendPostRequest(request);
        } else {
            throw new IllegalStateException("Either GET or POST server must be set in request object");
        }
        try {
            DOMHelper dom = new DOMHelper((InputStream)new BufferedInputStream(conn.getInputStream()), false);
            OWSExceptionReader.checkException(dom, dom.getBaseElement());
            return (ResponseType)this.readXMLResponse(dom, dom.getBaseElement(), request.getService(), dom.getBaseElement().getLocalName(), request.getVersion());
        }
        catch (IOException | DOMHelperException e) {
            throw new OWSException("Error while reading service response", (Exception)e);
        }
    }

    public HttpURLConnection sendGetRequest(OWSRequest request) throws OWSException {
        String requestString = null;
        try {
            if (request.getGetServer() == null) {
                throw new OWSException(invalidEndpoint);
            }
            requestString = this.buildURLQuery(request);
            URL url = new URL(requestString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(request.getConnectTimeOut());
            connection.setReadTimeout(request.getConnectTimeOut());
            connection.connect();
            if (connection.getResponseCode() > 202) {
                OGCExceptionReader.parseException((InputStream)connection.getErrorStream());
            }
            return connection;
        }
        catch (OGCException e) {
            throw new OWSException(e.getMessage());
        }
        catch (IOException e) {
            throw new OWSException(ioError + requestString, e);
        }
    }

    public HttpURLConnection sendPostRequest(OWSRequest request) throws OWSException {
        try {
            String endpoint = request.getPostServer();
            if (endpoint == null) {
                endpoint = request.getGetServer();
            }
            if (endpoint == null) {
                throw new OWSException(invalidEndpoint);
            }
            URL url = endpoint.endsWith("?") ? new URL(endpoint.substring(0, endpoint.length() - 1)) : new URL(endpoint);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(request.getConnectTimeOut());
            connection.setReadTimeout(request.getConnectTimeOut());
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-type", XML_MIME_TYPE);
            PrintStream out = new PrintStream(connection.getOutputStream());
            this.writeXMLQuery(out, request);
            out.flush();
            connection.connect();
            out.close();
            if (connection.getResponseCode() > 202) {
                OGCExceptionReader.parseException((InputStream)connection.getErrorStream());
            }
            return connection;
        }
        catch (OGCException e) {
            throw new OWSException(e.getMessage());
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                this.writeXMLQuery(buf, request);
                log.debug("I/O Error while sending request: \n" + buf);
            }
            throw new OWSException(ioError + request.getOperation(), e);
        }
    }

    public HttpURLConnection sendPostRequestWithQuery(OWSRequest request) throws OWSException {
        try {
            String endpoint = request.getGetServer();
            if (endpoint == null) {
                endpoint = request.getPostServer();
                request.setGetServer(endpoint);
            }
            if (endpoint == null) {
                throw new OWSException(invalidEndpoint);
            }
            String requestString = this.buildURLQuery(request);
            URL url = new URL(requestString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            return connection;
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                this.writeXMLQuery(buf, request);
                log.debug("I/O Error while sending request: \n" + buf);
            }
            throw new OWSException(ioError + request.getOperation(), e);
        }
    }

    public HttpURLConnection sendSoapRequest(OWSRequest request) throws OWSException {
        try {
            String endpoint = request.getPostServer();
            if (endpoint == null) {
                endpoint = request.getGetServer();
            }
            if (endpoint == null) {
                throw new OWSException(invalidEndpoint);
            }
            URL url = endpoint.endsWith("?") ? new URL(endpoint.substring(0, endpoint.length() - 1)) : new URL(endpoint);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-type", XML_MIME_TYPE);
            connection.setRequestProperty("SOAPAction", request.getOperation());
            PrintStream out = new PrintStream(connection.getOutputStream());
            String soapUri = request.getSoapVersion();
            if (soapUri == null) {
                soapUri = SOAP12_URI;
            }
            DOMHelper dom = new DOMHelper();
            dom.addUserPrefix("soap", soapUri);
            Element envElt = dom.createElement("soap:Envelope");
            Element bodyElt = dom.addElement((Node)envElt, "soap:Body");
            Element reqElt = this.buildXMLQuery(dom, request);
            bodyElt.appendChild(reqElt);
            dom.serialize((Node)envElt, (OutputStream)out, true);
            out.flush();
            connection.connect();
            out.close();
            if (connection.getResponseCode() > 202) {
                OGCExceptionReader.parseException((InputStream)connection.getErrorStream());
            }
            return connection;
        }
        catch (OGCException e) {
            throw new OWSException(e.getMessage());
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                this.writeXMLQuery(buf, request);
                log.debug("I/O Error while sending request: \n" + buf);
            }
            throw new OWSException(ioError + request.getOperation(), e);
        }
    }

    public OWSServiceCapabilities readCapabilities(DOMHelper dom, Element capsElt, String serviceType) throws OWSException {
        String version = dom.getAttributeValue(capsElt, "@version");
        String message = "Capabilities";
        try {
            OWSResponseReader reader = (OWSResponseReader)OGCRegistry.createReader((String)serviceType, (String)message, (String)version);
            OWSServiceCapabilities caps = (OWSServiceCapabilities)reader.readXMLResponse(dom, capsElt);
            return caps;
        }
        catch (IllegalStateException e) {
            String spec = serviceType + " " + message + " v" + version;
            throw new OWSException(unsupportedSpec + spec, e);
        }
    }

    public OWSServiceCapabilities getCapabilities(String server, String serviceType, String version) throws OWSException {
        try {
            GetCapabilitiesRequest request = new GetCapabilitiesRequest();
            request.setGetServer(server);
            request.setService(serviceType);
            request.setVersion(version);
            HttpURLConnection connection = this.sendGetRequest(request);
            DOMHelper dom = new DOMHelper(connection.getInputStream(), false);
            OWSServiceCapabilities caps = (OWSServiceCapabilities)this.readXMLResponse(dom, dom.getBaseElement(), serviceType, "Capabilities");
            return caps;
        }
        catch (IOException e) {
            throw new OWSException(ioError, e);
        }
        catch (DOMHelperException e) {
            throw new OWSException("Invalid XML Response", (Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            String spec = serviceType + " Capabilities v" + version;
            throw new OWSException(unsupportedSpec + spec, e);
        }
    }

    static {
        OWSUtils.loadRegistry();
    }
}

