/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.fes;

import net.opengis.fes.v20.BBOX;
import net.opengis.fes.v20.BinarySpatialOp;
import net.opengis.fes.v20.BinaryTemporalOp;
import net.opengis.fes.v20.GMLExpression;
import net.opengis.fes.v20.TemporalOperatorName;
import net.opengis.fes.v20.impl.FESFactory;
import net.opengis.gml.v32.AbstractTimeGeometricPrimitive;
import net.opengis.gml.v32.Envelope;
import net.opengis.gml.v32.TimeInstant;
import net.opengis.gml.v32.TimePeriod;
import org.vast.ogc.gml.GMLUtils;
import org.vast.util.Bbox;
import org.vast.util.TimeExtent;

public class FESRequestUtils {
    protected static String DEFAULT_TIME_PROPERTY = "time";
    static FESFactory filterFactory = new FESFactory();
    static GMLUtils gmlUtils = new GMLUtils("3.2");

    public static TimeExtent filterToTimeExtent(BinaryTemporalOp temporalFilter) {
        if (temporalFilter != null) {
            AbstractTimeGeometricPrimitive timePrimitive = (AbstractTimeGeometricPrimitive)((GMLExpression)temporalFilter.getOperand2()).getGmlObject();
            return gmlUtils.timePrimitiveToTimeExtent(timePrimitive);
        }
        return new TimeExtent();
    }

    public static BinaryTemporalOp timeExtentToFilter(TimeExtent timeExtent) {
        AbstractTimeGeometricPrimitive timePrim = gmlUtils.timeExtentToTimePrimitive(timeExtent, false);
        BinaryTemporalOp temporalFilter = timePrim instanceof TimeInstant ? filterFactory.newTemporalOp(TemporalOperatorName.T_EQUALS, DEFAULT_TIME_PROPERTY, (AbstractTimeGeometricPrimitive)((TimeInstant)timePrim)) : filterFactory.newTemporalOp(TemporalOperatorName.DURING, DEFAULT_TIME_PROPERTY, (AbstractTimeGeometricPrimitive)((TimePeriod)timePrim));
        return temporalFilter;
    }

    public static Bbox filterToBbox(BinarySpatialOp spatialFilter) {
        if (spatialFilter instanceof BBOX) {
            GMLExpression exp = (GMLExpression)((BBOX)spatialFilter).getOperand2();
            Envelope env = (Envelope)exp.getGmlObject();
            return GMLUtils.envelopeToBbox((Envelope)env);
        }
        return new Bbox();
    }

    public static BinarySpatialOp bboxToFilter(Bbox bbox) {
        Envelope gmlEnv = gmlUtils.bboxToEnvelope(bbox);
        return filterFactory.newBBOX("featureOfInterest/*/shape", gmlEnv);
    }
}

