/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.fes;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import net.opengis.fes.v20.BinarySpatialOp;
import net.opengis.fes.v20.BinaryTemporalOp;
import net.opengis.fes.v20.FilterCapabilities;
import net.opengis.fes.v20.ValueReference;
import org.vast.ows.OWSCommonUtils;
import org.vast.ows.OWSException;
import org.vast.ows.fes.FESRequestUtils;
import org.vast.ows.fes.FESStaxBindings;
import org.vast.util.Bbox;
import org.vast.util.TimeExtent;
import org.vast.xml.DOMHelper;
import org.vast.xml.XMLImplFinder;
import org.vast.xml.XMLReaderException;
import org.vast.xml.XMLWriterException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FESUtils
extends OWSCommonUtils {
    public static final String FES = "FES";
    public static final String V2_0 = "2.0";
    protected static Pattern NS_DECL_PATTERN = Pattern.compile("xmlns\\(.*\\)(,xmlns\\(.*\\))*");
    protected static Pattern NS_DECL_SPLIT = Pattern.compile("(\\),)?xmlns\\(");
    FESStaxBindings filterBindings = new FESStaxBindings(true);

    public FESUtils(String version) {
    }

    public BinaryTemporalOp readKVPTemporalFilter(String arg, Map<String, String> namespaceMap) throws OWSException {
        try {
            int firstComma = arg.indexOf(44);
            String valueRef = arg.substring(0, firstComma);
            String isoTime = arg.substring(firstComma + 1);
            TimeExtent time = this.parseTimeArg(isoTime);
            BinaryTemporalOp timeOp = FESRequestUtils.timeExtentToFilter(time);
            ((ValueReference)timeOp.getOperand1()).setValue(valueRef);
            return timeOp;
        }
        catch (Exception e) {
            throw new OWSException("Invalid temporal filter: " + arg);
        }
    }

    public BinarySpatialOp readKVPSpatialFilter(String arg, Map<String, String> namespaceMap) throws OWSException {
        try {
            int firstComma = arg.indexOf(44);
            String valueRef = arg.substring(0, firstComma);
            String bboxString = arg.substring(firstComma + 1);
            Bbox bbox = this.parseBboxArg(bboxString);
            BinarySpatialOp spatialOp = FESRequestUtils.bboxToFilter(bbox);
            ((ValueReference)spatialOp.getOperand1()).setValue(valueRef);
            return spatialOp;
        }
        catch (Exception e) {
            throw new OWSException("Invalid spatial filter: " + arg);
        }
    }

    public Map<String, String> readKVPNamespaces(String argValue) throws OWSException {
        String[] nsList;
        HashMap<String, String> namespaceMap = new HashMap<String, String>();
        for (String ns : nsList = NS_DECL_SPLIT.split(argValue)) {
            if (ns.length() <= 0) continue;
            String[] nsElts = ns.split(",");
            namespaceMap.put(nsElts[0], nsElts[1]);
        }
        return namespaceMap;
    }

    public BinaryTemporalOp readXMLTemporalFilter(Element timeOpElt) throws XMLReaderException {
        try {
            DOMSource domSrc = new DOMSource(timeOpElt);
            XMLStreamReader reader = XMLImplFinder.getStaxInputFactory().createXMLStreamReader(domSrc);
            reader.nextTag();
            return (BinaryTemporalOp)this.filterBindings.readTemporalOps(reader);
        }
        catch (Exception e) {
            throw new XMLReaderException("Error while reading temporal filter", (Node)timeOpElt, e);
        }
    }

    public Element writeTemporalFilter(DOMHelper dom, BinaryTemporalOp temporalOp) throws XMLWriterException {
        try {
            DOMResult result = new DOMResult(dom.createElement("fragment"));
            XMLStreamWriter writer = XMLImplFinder.getStaxOutputFactory().createXMLStreamWriter(result);
            this.filterBindings.setNamespacePrefixes(writer);
            this.filterBindings.declareNamespacesOnRootElement();
            this.filterBindings.writeTemporalOps(writer, temporalOp);
            return (Element)result.getNode().getFirstChild();
        }
        catch (Exception e) {
            throw new XMLWriterException("Error while writing temporal filter", e);
        }
    }

    public BinarySpatialOp readXMLSpatialFilter(Element spatialOpElt) throws XMLReaderException {
        try {
            DOMSource domSrc = new DOMSource(spatialOpElt);
            XMLStreamReader reader = XMLImplFinder.getStaxInputFactory().createXMLStreamReader(domSrc);
            reader.nextTag();
            return (BinarySpatialOp)this.filterBindings.readSpatialOps(reader);
        }
        catch (Exception e) {
            throw new XMLReaderException("Error while reading spatial filter", (Node)spatialOpElt, e);
        }
    }

    public Element writeSpatialFilter(DOMHelper dom, BinarySpatialOp spatialOp) throws XMLWriterException {
        try {
            DOMResult result = new DOMResult(dom.createElement("fragment"));
            XMLStreamWriter writer = XMLImplFinder.getStaxOutputFactory().createXMLStreamWriter(result);
            this.filterBindings.setNamespacePrefixes(writer);
            this.filterBindings.declareNamespacesOnRootElement();
            this.filterBindings.writeSpatialOps(writer, spatialOp);
            return (Element)result.getNode().getFirstChild();
        }
        catch (Exception e) {
            throw new XMLWriterException("Error while writing temporal filter", e);
        }
    }

    public FilterCapabilities readFilterCapabilities(Element filterCapsElt) throws XMLReaderException {
        try {
            DOMSource domSrc = new DOMSource(filterCapsElt);
            XMLStreamReader reader = XMLImplFinder.getStaxInputFactory().createXMLStreamReader(domSrc);
            reader.nextTag();
            return this.filterBindings.readFilterCapabilities(reader);
        }
        catch (Exception e) {
            throw new XMLReaderException("Error while reading filter capabilities", (Node)filterCapsElt, e);
        }
    }

    public Element writeFilterCapabilities(DOMHelper dom, FilterCapabilities filterCaps) throws XMLWriterException {
        try {
            DOMResult result = new DOMResult(dom.createElement("fragment"));
            XMLStreamWriter writer = XMLImplFinder.getStaxOutputFactory().createXMLStreamWriter(result);
            this.filterBindings.setNamespacePrefixes(writer);
            this.filterBindings.declareNamespacesOnRootElement();
            this.filterBindings.writeFilterCapabilities(writer, filterCaps);
            return (Element)result.getNode().getFirstChild();
        }
        catch (Exception e) {
            throw new XMLWriterException("Error while writing filter capabilities", e);
        }
    }

    public void resetIdCounters() {
    }
}

