/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sas;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import org.vast.cdm.common.CDMException;
import org.vast.cdm.common.DataHandler;
import org.vast.ogc.OGCException;
import org.vast.ogc.OGCExceptionReader;
import org.vast.swe.SWEFilter;
import org.vast.swe.SWEReader;
import org.vast.util.DateTimeFormat;
import org.vast.util.ReaderException;
import org.vast.xml.DOMHelper;
import org.vast.xml.DOMHelperException;
import org.vast.xml.XMLReaderException;
import org.w3c.dom.Element;

public class SASAlertReader
extends SWEReader {
    protected SWEFilter streamFilter;
    protected double timestamp;
    protected DateTimeFormat timeFormat = new DateTimeFormat();

    public void parse(InputStream inputStream, DataHandler handler) throws IOException {
        try {
            this.dataHandler = handler;
            this.streamFilter = new SWEFilter(inputStream);
            this.streamFilter.setDataElementName("AlertData");
            DOMHelper dom = new DOMHelper((InputStream)this.streamFilter, false);
            OGCExceptionReader.checkException((DOMHelper)dom);
            Element rootElement = dom.getRootElement();
            Element timestampElt = dom.getElement(rootElement, "Timestamp");
            String timestampISO = dom.getElementValue(timestampElt);
            this.timestamp = this.timeFormat.parseIso(timestampISO);
            this.dataParser = this.createDataParser();
        }
        catch (IllegalStateException e) {
            throw new ReaderException("No reader found for SWECommon", (Exception)e);
        }
        catch (DOMHelperException e) {
            throw new XMLReaderException("Error while parsing Observation XML", (Exception)((Object)e));
        }
        catch (OGCException e) {
            throw new XMLReaderException(e.getMessage());
        }
        catch (ParseException e) {
            throw new XMLReaderException("Error while parsing the ISO-formatted timestamp", (Exception)e);
        }
    }

    public InputStream getDataStream() throws IOException {
        this.streamFilter.startReadingData();
        return this.streamFilter;
    }

    public double getTimestamp() throws CDMException {
        return this.timestamp;
    }
}

