/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sas;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.vast.ows.AbstractCapabilitiesReader;
import org.vast.ows.OWSException;
import org.vast.ows.OWSServiceCapabilities;
import org.vast.ows.sas.SASException;
import org.vast.ows.sas.SASLayerCapabilities;
import org.vast.util.ExceptionSystem;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SASCapabilitiesReader
extends AbstractCapabilitiesReader {
    @Override
    protected void readContents(DOMHelper dom, Element capsElt, OWSServiceCapabilities serviceCaps) throws OWSException {
        NodeList subList = dom.getElements(capsElt, "Contents/SubscriptionOfferingList/SubscriptionOffering");
        if (subList == null) {
            throw new SASException("Capabilities from an SAS service must have subscription offering");
        }
        for (int i = 0; i < subList.getLength(); ++i) {
            Element subElt = (Element)subList.item(i);
            String subName = "Subscription " + Integer.toString(i + 1);
            SASLayerCapabilities layerCaps = new SASLayerCapabilities();
            try {
                String subscriptionID = dom.getElementValue(subElt, "SubscriptionOfferingID");
                if (subscriptionID == null) {
                    throw new SASException("a subscriptionID must be specified");
                }
                Element messageStructureElt = dom.getElement(subElt, "messageStructure");
                if (messageStructureElt == null) {
                    throw new SASException("a message structure in SWEcommon must be specified");
                }
                Element sweBlockElt = dom.getElement(messageStructureElt, "DataBlockDefinition/components");
                String messageStructureName = dom.getAttributeValue(sweBlockElt, "name");
                String messageStructure = "";
                String SweDataComponent = "";
                try {
                    TransformerFactory tf = TransformerFactory.newInstance();
                    Transformer trans = tf.newTransformer();
                    StringWriter sw1 = new StringWriter();
                    trans.transform(new DOMSource(messageStructureElt), new StreamResult(sw1));
                    messageStructure = sw1.toString();
                    StringWriter sw2 = new StringWriter();
                    trans.transform(new DOMSource(sweBlockElt), new StreamResult(sw2));
                    SweDataComponent = sw2.toString();
                }
                catch (TransformerConfigurationException e) {
                    e.printStackTrace();
                }
                catch (TransformerFactoryConfigurationError e) {
                    e.printStackTrace();
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                }
                int initialIndex = SweDataComponent.indexOf("?", 5) + 2;
                SweDataComponent = SweDataComponent.substring(initialIndex);
                int startIndex = SweDataComponent.indexOf(">") + 3;
                int lastIndex = SweDataComponent.lastIndexOf("<");
                SweDataComponent = SweDataComponent.substring(startIndex, lastIndex);
                String sensorID = dom.getElementValue(subElt, "member/SensorID");
                if (sensorID == null) {
                    throw new SASException("a sensorID must be specified");
                }
                String frequency = "unknown";
                Element frequencyElt = dom.getElement(subElt, "member/reportingFrequency/Quantity");
                if (frequencyElt != null) {
                    String frequencyValue = dom.getElementValue(frequencyElt, "value");
                    String frequencyUnit = dom.getAttributeValue(frequencyElt, "uom/code");
                    frequency = frequencyValue + " " + frequencyUnit;
                }
                layerCaps.setMessageStructureName(messageStructureName);
                layerCaps.setMessageStructure(messageStructure);
                layerCaps.setSweDataComponentString(SweDataComponent);
                layerCaps.setTitle(subName);
                layerCaps.setSubscriptionOfferingID(subscriptionID);
                layerCaps.setSensorID(sensorID);
                layerCaps.setFrequency(frequency);
                layerCaps.setParent(serviceCaps);
            }
            catch (SASException e) {
                String message = "Error while parsing capabilities document XML in subscription " + layerCaps.getSubscriptionOfferingIDList().get(0);
                ExceptionSystem.display((Throwable)new SASException(message, e));
                continue;
            }
            serviceCaps.getLayers().add(layerCaps);
        }
    }

    @Override
    public OWSServiceCapabilities readXMLResponse(DOMHelper dom, Element capabilitiesElt) throws OWSException {
        OWSServiceCapabilities serviceCaps = new OWSServiceCapabilities();
        String version = dom.getAttributeValue(capabilitiesElt, "version");
        serviceCaps.setVersion(version);
        this.readContents(dom, capabilitiesElt, serviceCaps);
        return serviceCaps;
    }
}

