/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sas;

import org.vast.ogc.OGCRegistry;
import org.vast.ows.AbstractRequestWriter;
import org.vast.ows.GetCapabilitiesRequest;
import org.vast.ows.OWSException;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class SASGetCapabilitiesWriter
extends AbstractRequestWriter<GetCapabilitiesRequest> {
    @Override
    public String buildURLQuery(GetCapabilitiesRequest query) throws OWSException {
        StringBuffer urlBuff = new StringBuffer(query.getGetServer());
        urlBuff.append("service=" + query.getService());
        urlBuff.append("&version=" + query.getVersion());
        urlBuff.append("&request=" + query.getOperation());
        if (query.getSection() != null) {
            urlBuff.append("&SECTION=" + query.getSection());
        }
        return urlBuff.toString();
    }

    @Override
    public Element buildXMLQuery(DOMHelper dom, GetCapabilitiesRequest request) throws OWSException {
        String nsUri = OGCRegistry.getNamespaceURI((String)request.getService(), (String)request.getVersion());
        dom.addUserPrefix("_NIL_", nsUri);
        Element rootElt = dom.createElement(request.getOperation());
        dom.setAttributeValue(rootElt, "version", request.getVersion());
        dom.setAttributeValue(rootElt, "service", request.getService());
        if (request.getSection() != null) {
            dom.setElementValue(rootElt, "section", request.getSection());
        }
        return rootElt;
    }
}

