/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vast.ows.GetCapabilitiesRequest;
import org.vast.ows.OWSException;
import org.vast.ows.OWSRequest;
import org.vast.ows.OWSResponse;
import org.vast.ows.OWSUtils;
import org.vast.ows.util.PostRequestFilter;
import org.vast.xml.DOMHelper;
import org.vast.xml.DOMHelperException;
import org.w3c.dom.Element;

public abstract class OWSServlet
extends HttpServlet {
    private static final long serialVersionUID = 4970153267344348035L;
    protected static final String invalidKVPRequestMsg = "Invalid KVP request. Please check your syntax";
    protected static final String invalidXMLRequestMsg = "Invalid XML request. Please check your syntax";
    protected static final String internalErrorMsg = "Internal Error while processing the request. Please contact maintenance";
    private static Logger log = LoggerFactory.getLogger(OWSServlet.class);
    protected String owsVersion = "1.0";
    protected OWSUtils owsUtils = new OWSUtils();
    protected DOMHelper capsHelper;

    protected abstract void handleRequest(OWSRequest var1) throws Exception;

    protected void handleRequest(GetCapabilitiesRequest request) throws Exception {
        this.sendCapabilities(request.getSection(), request.getResponseStream());
    }

    protected void sendCapabilities(String section, OutputStream resp) throws Exception {
        try {
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("indent", "yes");
            DOMSource input = new DOMSource(this.capsHelper.getRootElement());
            StreamResult output = new StreamResult(resp);
            serializer.transform(input, output);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void updateCapabilities(InputStream capsFile) {
        try {
            this.capsHelper = new DOMHelper(capsFile, false);
        }
        catch (DOMHelperException e) {
            e.printStackTrace();
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        log.info("GET REQUEST from IP " + req.getRemoteAddr());
        this.processRequest(req, resp, false);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        log.info("POST REQUEST from IP " + req.getRemoteAddr());
        String contentType = req.getContentType();
        boolean isXml = contentType == null || contentType.contains("xml");
        this.processRequest(req, resp, isXml);
    }

    protected boolean isClientDisconnected(HttpServletRequest req, HttpServletResponse resp) {
        try {
            resp.flushBuffer();
        }
        catch (IOException e) {
            return true;
        }
        return false;
    }

    protected void processRequest(HttpServletRequest req, HttpServletResponse resp, boolean isXmlRequest) {
        String requestURL = req.getRequestURL().toString();
        OWSRequest request = null;
        String soapVersion = null;
        try {
            request = this.parseRequest(req, resp, isXmlRequest);
            if (request != null) {
                soapVersion = request.getSoapVersion();
                resp.setContentType("text/xml");
                request.setHttpRequest(req);
                request.setHttpResponse(resp);
                request.setPostServer(requestURL);
                if (request instanceof GetCapabilitiesRequest) {
                    this.handleRequest(request);
                } else {
                    this.handleRequest(request);
                }
                resp.getOutputStream().flush();
            }
        }
        catch (OWSException e) {
            try {
                resp.setContentType("text/xml");
                if (!this.isClientDisconnected(req, resp)) {
                    log.trace(e.getMessage(), (Throwable)e);
                    String version = null;
                    if (request != null) {
                        version = request.getVersion();
                    }
                    if (version == null) {
                        version = this.getDefaultVersion();
                    }
                    e.setSoapVersion(soapVersion);
                    this.owsUtils.writeXMLException(new BufferedOutputStream((OutputStream)resp.getOutputStream()), this.getServiceType(), version, e);
                    resp.getOutputStream().close();
                }
            }
            catch (IOException e1) {
                log.error("Cannot send OWS exception report to client", (Throwable)e);
            }
        }
        catch (SecurityException e) {
            try {
                resp.sendError(403, e.getMessage());
            }
            catch (IOException iOException) {}
        }
        catch (Exception e) {
            try {
                resp.sendError(500, e.getMessage());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected OWSRequest parseRequest(HttpServletRequest req, HttpServletResponse resp, boolean isXmlRequest) throws Exception {
        String soapVersion = null;
        try {
            if (isXmlRequest) {
                PostRequestFilter xmlRequest = new PostRequestFilter(new BufferedInputStream((InputStream)req.getInputStream()));
                DOMHelper dom = new DOMHelper((InputStream)xmlRequest, false);
                Element requestElt = dom.getBaseElement();
                soapVersion = this.getSoapVersion(dom);
                if (soapVersion != null) {
                    requestElt = this.getSoapBody(dom);
                }
                OWSRequest owsRequest = this.owsUtils.readXMLQuery(dom, requestElt);
                if (soapVersion != null) {
                    owsRequest.setSoapVersion(soapVersion);
                }
                return owsRequest;
            }
            String queryString = req.getQueryString();
            if (queryString == null) {
                throw new IllegalArgumentException();
            }
            return this.owsUtils.readURLQuery(queryString);
        }
        catch (IllegalArgumentException e) {
            try {
                resp.sendError(400, invalidKVPRequestMsg);
                log.trace(invalidKVPRequestMsg, (Throwable)e);
            }
            catch (IOException dom) {}
        }
        catch (IOException | DOMHelperException e) {
            try {
                resp.sendError(400, invalidXMLRequestMsg);
                log.trace(invalidXMLRequestMsg, e);
            }
            catch (IOException dom) {}
        }
        catch (OWSException e) {
            try {
                resp.setContentType("text/xml");
                String version = req.getParameter("version");
                if (version == null) {
                    version = this.getDefaultVersion();
                }
                e.setSoapVersion(soapVersion);
                this.owsUtils.writeXMLException(new BufferedOutputStream((OutputStream)resp.getOutputStream()), this.getServiceType(), version, e);
                log.trace(e.getMessage(), (Throwable)e);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    protected String getSoapVersion(DOMHelper dom) {
        Element requestElt = dom.getBaseElement();
        String nsUri = requestElt.getNamespaceURI();
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(nsUri) || "http://www.w3.org/2003/05/soap-envelope".equals(nsUri)) {
            return nsUri;
        }
        return null;
    }

    protected Element getSoapBody(DOMHelper dom) throws IOException {
        Element requestElt = dom.getBaseElement();
        if ((requestElt = dom.getElement(requestElt, "Body/*")) == null) {
            throw new IOException("No request in SOAP body");
        }
        return requestElt;
    }

    protected void sendResponse(OWSRequest request, OWSResponse resp) throws OWSException, IOException {
        BufferedOutputStream os = new BufferedOutputStream(request.getResponseStream());
        this.owsUtils.writeXMLResponse(os, resp, request.getVersion(), request.getSoapVersion());
        ((OutputStream)os).flush();
    }

    protected String getDefaultVersion() {
        return "1.0";
    }

    protected abstract String getServiceType();
}

