/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.server;

import java.util.Hashtable;
import org.vast.ows.OWSException;
import org.vast.ows.OWSRequest;
import org.vast.ows.OWSUtils;
import org.vast.ows.server.OWSServlet;
import org.vast.ows.server.WCSHandler;
import org.vast.ows.wcs.DescribeCoverageRequest;
import org.vast.ows.wcs.GetCoverageRequest;
import org.vast.ows.wcs.WCSException;

public abstract class WCSServlet
extends OWSServlet {
    private static final long serialVersionUID = 7155979257491196521L;
    protected String DEFAULT_VERSION = "1.0";
    protected OWSUtils owsUtils = new OWSUtils();
    protected Hashtable<String, WCSHandler> dataSetHandlers = new Hashtable();

    @Override
    public void handleRequest(OWSRequest request) throws Exception {
        if (!(request instanceof GetCoverageRequest)) {
            throw new OWSException("Unsupported operation " + request.getOperation());
        }
        this.processQuery((GetCoverageRequest)request);
    }

    protected void processQuery(GetCoverageRequest query) throws Exception {
        String coverage = query.getCoverage();
        WCSHandler handler = this.dataSetHandlers.get(coverage);
        if (handler == null) {
            throw new WCSException("COVERAGE " + coverage + " is unavailable on this server");
        }
        handler.getCoverage(query);
    }

    protected void processQuery(DescribeCoverageRequest query) throws Exception {
    }

    public void addDataSetHandler(String coverageID, WCSHandler handlerClass) {
        this.dataSetHandlers.put(coverageID, handlerClass);
    }

    public void removeDataSetHandler(String dataSetID) {
        this.dataSetHandlers.remove(dataSetID);
    }
}

