/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.server;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vast.ows.GetCapabilitiesRequest;
import org.vast.ows.OWSException;
import org.vast.ows.OWSRequest;
import org.vast.ows.OWSUtils;
import org.vast.ows.server.OWSServlet;
import org.vast.ows.util.PostRequestFilter;
import org.vast.ows.wps.DescribeProcessRequest;
import org.vast.ows.wps.ExecuteProcessRequest;
import org.vast.ows.wps.WPSException;
import org.vast.ows.wps.WPSUtils;
import org.vast.xml.DOMHelper;
import org.vast.xml.DOMHelperException;

public abstract class WPSServlet
extends OWSServlet {
    private static final long serialVersionUID = 6940984824581209178L;
    private static final Logger log = LoggerFactory.getLogger(WPSServlet.class);
    protected OWSUtils owsUtils = new OWSUtils();
    private WPSUtils wpsUtils;
    protected DOMHelper describeProcessDomHelper;

    protected void processQuery(GetCapabilitiesRequest query) throws Exception {
        this.sendCapabilities("ALL", query.getResponseStream());
    }

    protected void processQuery(DescribeProcessRequest query) throws Exception {
        if (query.getRequestFormat() == null) {
            throw new WPSException("A DescribeProcess WPS request must specify an request format argument");
        }
        if (query.getOffering() == null) {
            throw new WPSException("A DescribeProcess WPS request must specify an request offering argument");
        }
        SOAPMessage describeProcessSOAPMessage = this.wpsUtils.createSoapMessage(this.describeProcessDomHelper);
        describeProcessSOAPMessage.writeTo(query.getResponseStream());
    }

    private void sendDescribeProcess(String string, OutputStream responseStream) {
    }

    protected void processQuery(ExecuteProcessRequest query) {
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        block23: {
            OWSRequest query = null;
            try {
                String requestURL = req.getRequestURL().toString();
                String queryString = req.getQueryString();
                if (queryString == null) {
                    resp.sendError(400, "Invalid request");
                }
                log.info("GET REQUEST: " + queryString + " from IP " + req.getRemoteAddr());
                query = this.owsUtils.readURLQuery(queryString, "WPS");
                resp.setContentType("text/xml");
                query.setHttpResponse(resp);
                query.setGetServer(requestURL);
                if (query instanceof GetCapabilitiesRequest) {
                    this.processQuery((GetCapabilitiesRequest)query);
                    break block23;
                }
                throw new ServletException("WPS accept request of content type 'text/xml' only for theGetCapabilities request");
            }
            catch (WPSException e) {
                try {
                    resp.sendError(500, e.getMessage());
                }
                catch (IOException e1) {
                    e.printStackTrace();
                }
            }
            catch (OWSException e) {
                try {
                    resp.sendError(400, e.getMessage());
                }
                catch (IOException e1) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                throw new ServletException("Internal Error while processing the request. Please contact maintenance", (Throwable)e);
            }
            finally {
                try {
                    resp.getOutputStream().flush();
                    resp.getOutputStream().close();
                }
                catch (IOException e) {
                    throw new ServletException((Throwable)e);
                }
            }
        }
    }

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        OWSRequest query = null;
        log.info("POST REQUEST from IP " + req.getRemoteAddr());
        String requestURL = req.getRequestURL().toString();
        if (req.getContentType().equalsIgnoreCase("text/xml")) {
            try {
                PostRequestFilter xmlRequest = new PostRequestFilter(new BufferedInputStream((InputStream)req.getInputStream()));
                DOMHelper dom = new DOMHelper((InputStream)xmlRequest, false);
                query = this.owsUtils.readXMLQuery(dom, dom.getBaseElement());
                resp.setContentType("text/xml");
                query.setHttpResponse(resp);
                query.setPostServer(requestURL);
                if (query instanceof GetCapabilitiesRequest) {
                    this.processQuery((GetCapabilitiesRequest)query);
                }
                throw new ServletException("WPS accepts requests of content type 'text/xml' only for theGetCapabilities request");
            }
            catch (WPSException e) {
                try {
                    resp.sendError(500, e.getMessage());
                }
                catch (IOException e1) {
                    e.printStackTrace();
                }
            }
            catch (OWSException e) {
                try {
                    resp.sendError(400, e.getMessage());
                }
                catch (IOException e1) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                throw new ServletException("Internal Error while processing the request. Please contact maintenance", (Throwable)e);
            }
            finally {
                try {
                    resp.getOutputStream().flush();
                    resp.getOutputStream().close();
                }
                catch (IOException e) {
                    throw new ServletException((Throwable)e);
                }
            }
        } else if (req.getContentType().equalsIgnoreCase("application/soap+xml")) {
            try {
                PostRequestFilter soapRequest = new PostRequestFilter(new BufferedInputStream((InputStream)req.getInputStream()));
                query = this.wpsUtils.extractWPSRequest(soapRequest);
                resp.setContentType(req.getContentType());
                query.setHttpResponse(resp);
                query.setPostServer(requestURL);
                if (query instanceof GetCapabilitiesRequest) {
                    this.processQuery((GetCapabilitiesRequest)query);
                } else if (query instanceof DescribeProcessRequest) {
                    this.processQuery((DescribeProcessRequest)query);
                } else if (query instanceof DescribeProcessRequest) {
                    this.processQuery((ExecuteProcessRequest)query);
                }
            }
            catch (WPSException e) {
                try {
                    resp.sendError(500, e.getMessage());
                }
                catch (IOException e1) {
                    e.printStackTrace();
                }
            }
            catch (SOAPException e) {
                try {
                    resp.sendError(500, e.getMessage());
                }
                catch (IOException e1) {
                    e.printStackTrace();
                }
            }
            catch (OWSException e) {
                try {
                    resp.sendError(400, "Invalid request or unrecognized version");
                }
                catch (IOException e1) {
                    e.printStackTrace();
                }
            }
            catch (DOMHelperException e) {
                try {
                    resp.sendError(400, "Invalid XML request. Please check request format");
                }
                catch (IOException e1) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                throw new ServletException("Internal Error while processing the request. Please contact maintenance", (Throwable)e);
            }
            finally {
                try {
                    resp.getOutputStream().close();
                }
                catch (IOException e) {
                    throw new ServletException((Throwable)e);
                }
            }
        }
    }

    @Override
    protected String getServiceType() {
        return "WPS";
    }
}

