/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sld;

import org.vast.ows.sld.ScalarParameter;

public class Color {
    protected ScalarParameter red = new ScalarParameter();
    protected ScalarParameter green;
    protected ScalarParameter blue;
    protected ScalarParameter alpha;

    public static String toHexString(float r, float g, float b, boolean bgr) {
        String red = Integer.toHexString((int)(r * 255.0f));
        String green = Integer.toHexString((int)(g * 255.0f));
        String blue = Integer.toHexString((int)(b * 255.0f));
        if (red.length() == 1) {
            red = "0" + red;
        }
        if (green.length() == 1) {
            green = "0" + green;
        }
        if (blue.length() == 1) {
            blue = "0" + blue;
        }
        if (bgr) {
            return blue + green + red;
        }
        return red + green + blue;
    }

    public static String toHexString(float r, float g, float b, float a, boolean abgr) {
        String color = Color.toHexString(r, g, b, abgr);
        String alpha = Integer.toHexString((int)(a * 255.0f));
        if (alpha.length() == 1) {
            alpha = "0" + alpha;
        }
        if (abgr) {
            return alpha + color;
        }
        return color + alpha;
    }

    public Color() {
        this.red.setConstantValue(new Float(0.0f));
        this.green = new ScalarParameter();
        this.green.setConstantValue(new Float(0.0f));
        this.blue = new ScalarParameter();
        this.blue.setConstantValue(new Float(0.0f));
        this.alpha = new ScalarParameter();
        this.alpha.setConstantValue(new Float(1.0f));
    }

    public Color(float redVal, float greenVal, float blueVal, float alphaVal) {
        this();
        this.red.setConstantValue(Float.valueOf(redVal));
        this.green.setConstantValue(Float.valueOf(greenVal));
        this.blue.setConstantValue(Float.valueOf(blueVal));
        this.alpha.setConstantValue(Float.valueOf(alphaVal));
    }

    public Color(int redVal, int greenVal, int blueVal, int alphaVal) {
        this();
        this.red.setConstantValue(Float.valueOf((float)redVal / 255.0f));
        this.green.setConstantValue(Float.valueOf((float)greenVal / 255.0f));
        this.blue.setConstantValue(Float.valueOf((float)blueVal / 255.0f));
        this.alpha.setConstantValue(Float.valueOf((float)alphaVal / 255.0f));
    }

    public Color(String hexValue) {
        this();
        this.setFromHexValue(hexValue);
    }

    public boolean isConstant() {
        if (!this.red.isConstant()) {
            return false;
        }
        if (!this.green.isConstant()) {
            return false;
        }
        if (!this.blue.isConstant()) {
            return false;
        }
        return this.alpha.isConstant();
    }

    public void setFromHexValue(String hexValue) {
        String rVal = hexValue.substring(0, 2);
        this.red.setConstantValue(Float.valueOf((float)Integer.parseInt(rVal, 16) / 255.0f));
        String gVal = hexValue.substring(2, 4);
        this.green.setConstantValue(Float.valueOf((float)Integer.parseInt(gVal, 16) / 255.0f));
        String bVal = hexValue.substring(4, 6);
        this.blue.setConstantValue(Float.valueOf((float)Integer.parseInt(bVal, 16) / 255.0f));
        this.alpha.setConstantValue(Float.valueOf(1.0f));
    }

    public ScalarParameter getAlpha() {
        return this.alpha;
    }

    public void setAlpha(ScalarParameter alpha) {
        this.alpha = alpha;
    }

    public ScalarParameter getBlue() {
        return this.blue;
    }

    public void setBlue(ScalarParameter blue) {
        this.blue = blue;
    }

    public ScalarParameter getGreen() {
        return this.green;
    }

    public void setGreen(ScalarParameter green) {
        this.green = green;
    }

    public ScalarParameter getRed() {
        return this.red;
    }

    public void setRed(ScalarParameter red) {
        this.red = red;
    }

    public float getAlphaValue() {
        return ((Float)this.alpha.getConstantValue()).floatValue();
    }

    public void setAlphaValue(float alphaVal) {
        this.alpha.setConstantValue(Float.valueOf(alphaVal));
    }

    public float getBlueValue() {
        return ((Float)this.blue.getConstantValue()).floatValue();
    }

    public void setBlueValue(float blueVal) {
        this.blue.setConstantValue(Float.valueOf(blueVal));
    }

    public float getGreenValue() {
        return ((Float)this.green.getConstantValue()).floatValue();
    }

    public void setGreenValue(float greenVal) {
        this.green.setConstantValue(Float.valueOf(greenVal));
    }

    public float getRedValue() {
        return ((Float)this.red.getConstantValue()).floatValue();
    }

    public void setRedValue(float redVal) {
        this.red.setConstantValue(Float.valueOf(redVal));
    }
}

