/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sld;

import org.vast.ows.sld.MappingFunction;
import org.vast.ows.sld.ScalarParameter;
import org.vast.ows.sld.functions.FunctionReader;
import org.vast.ows.sld.functions.LookUpTable1D;
import org.vast.ows.sld.functions.StringIdProvider;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class ParameterReader {
    private FunctionReader functionReader = new FunctionReader();

    public ScalarParameter readPropertyName(DOMHelper dom, Element paramElt) {
        if (paramElt == null) {
            return null;
        }
        ScalarParameter param = new ScalarParameter();
        String pName = dom.getElementValue(paramElt, "");
        param.setPropertyName(pName);
        return param;
    }

    public ScalarParameter readCssParameter(DOMHelper dom, Element paramElt, StringIdProvider stringIdProvider) {
        ScalarParameter param;
        if (paramElt == null) {
            return null;
        }
        if (dom.existElement(paramElt, "PropertyName")) {
            Element propNameElt = dom.getElement(paramElt, "PropertyName");
            param = this.readPropertyName(dom, propNameElt);
        } else {
            param = dom.existElement(paramElt, "*") ? this.readParamWithMappingFunction(dom, paramElt, stringIdProvider) : this.readCssParameterValue(dom, paramElt);
        }
        return param;
    }

    public ScalarParameter readCssParameter(DOMHelper dom, Element paramElt) {
        return this.readCssParameter(dom, paramElt, null);
    }

    public ScalarParameter readCssParameterValue(DOMHelper dom, Element paramElt) {
        String val = dom.getElementValue(paramElt, "");
        ScalarParameter param = new ScalarParameter();
        try {
            float numVal = Float.parseFloat(val);
            param.setConstantValue(Float.valueOf(numVal));
        }
        catch (NumberFormatException e) {
            param.setConstantValue(val);
        }
        return param;
    }

    public ScalarParameter readParamWithMappingFunction(DOMHelper dom, Element paramElt, StringIdProvider stringIdProvider) {
        ScalarParameter param = new ScalarParameter();
        Element funcElt = dom.getFirstChildElement(paramElt);
        String pName = dom.getElementValue(funcElt, "PropertyName");
        param.setPropertyName(pName);
        MappingFunction function = this.functionReader.readFunction(dom, funcElt, stringIdProvider);
        param.setMappingFunction(function);
        return param;
    }

    public MappingFunction readLUT(DOMHelper dom, Element lutElt) {
        String values = dom.getElementValue(lutElt, "TableValues");
        String[] valueTable = values.split(" ");
        int tupleCount = valueTable.length / 2;
        double[][] tableData = new double[2][tupleCount];
        for (int i = 0; i < tupleCount; ++i) {
            tableData[0][i] = Double.parseDouble(valueTable[2 * i]);
            tableData[1][i] = Double.parseDouble(valueTable[2 * i + 1]);
        }
        LookUpTable1D function = new LookUpTable1D(tableData);
        return function;
    }
}

