/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sld;

import java.net.URI;
import java.net.URISyntaxException;
import org.vast.ows.sld.Color;
import org.vast.ows.sld.Dimensions;
import org.vast.ows.sld.Fill;
import org.vast.ows.sld.Font;
import org.vast.ows.sld.Geometry;
import org.vast.ows.sld.Graphic;
import org.vast.ows.sld.GraphicImage;
import org.vast.ows.sld.GraphicMark;
import org.vast.ows.sld.GridBorderSymbolizer;
import org.vast.ows.sld.GridFillSymbolizer;
import org.vast.ows.sld.GridMeshSymbolizer;
import org.vast.ows.sld.LineSymbolizer;
import org.vast.ows.sld.ParameterReader;
import org.vast.ows.sld.PointSymbolizer;
import org.vast.ows.sld.PolygonSymbolizer;
import org.vast.ows.sld.RasterChannel;
import org.vast.ows.sld.RasterSymbolizer;
import org.vast.ows.sld.ScalarParameter;
import org.vast.ows.sld.Stroke;
import org.vast.ows.sld.Symbolizer;
import org.vast.ows.sld.TextSymbolizer;
import org.vast.ows.sld.TextureSymbolizer;
import org.vast.ows.sld.VectorSymbolizer;
import org.vast.ows.sld.functions.StringIdProvider;
import org.vast.util.MessageSystem;
import org.vast.util.URIResolver;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SLDReader {
    private ParameterReader cssReader = new ParameterReader();
    protected StringIdProvider iconIdProvider;

    public SLDReader() {
    }

    public SLDReader(StringIdProvider iconIdProvider) {
        this();
        this.iconIdProvider = iconIdProvider;
    }

    public Symbolizer readSymbolizer(DOMHelper dom, Element symElt) {
        Symbolizer sym = null;
        if (symElt.getLocalName().equals("PointSymbolizer")) {
            sym = this.readPoint(dom, symElt);
        } else if (symElt.getLocalName().equals("LineSymbolizer")) {
            sym = this.readLine(dom, symElt);
        } else if (symElt.getLocalName().equals("PolygonSymbolizer")) {
            sym = this.readPolygon(dom, symElt);
        } else if (symElt.getLocalName().equals("VectorSymbolizer")) {
            sym = this.readVector(dom, symElt);
        } else if (symElt.getLocalName().equals("TextSymbolizer")) {
            sym = this.readText(dom, symElt);
        } else if (symElt.getLocalName().equals("GridMeshSymbolizer")) {
            sym = this.readGridMesh(dom, symElt);
        } else if (symElt.getLocalName().equals("GridFillSymbolizer")) {
            sym = this.readGridFill(dom, symElt);
        } else if (symElt.getLocalName().equals("GridBorderSymbolizer")) {
            sym = this.readGridBorder(dom, symElt);
        } else if (symElt.getLocalName().equals("RasterSymbolizer")) {
            sym = this.readRaster(dom, symElt);
        } else if (symElt.getLocalName().equals("TextureSymbolizer")) {
            sym = this.readTexture(dom, symElt);
        } else {
            MessageSystem.display((String)("Unknown Symbolizer: " + symElt.getLocalName()), (boolean)true);
        }
        return sym;
    }

    public PointSymbolizer readPoint(DOMHelper dom, Element symElt) {
        PointSymbolizer pointSym = new PointSymbolizer();
        this.readGeometryElt(pointSym, dom, symElt);
        Element graphicElt = dom.getElement(symElt, "Graphic");
        Graphic graphic = this.readGraphic(dom, graphicElt);
        pointSym.setGraphic(graphic);
        return pointSym;
    }

    public LineSymbolizer readLine(DOMHelper dom, Element symElt) {
        LineSymbolizer lineSym = new LineSymbolizer();
        this.readGeometryElt(lineSym, dom, symElt);
        Element dimElt = dom.getElement(symElt, "Dimensions");
        Dimensions dims = this.readDimensions(dom, dimElt);
        lineSym.setDimensions(dims);
        Element strokeElt = dom.getElement(symElt, "Stroke");
        Stroke stroke = this.readStroke(dom, strokeElt);
        lineSym.setStroke(stroke);
        return lineSym;
    }

    public PolygonSymbolizer readPolygon(DOMHelper dom, Element symElt) {
        PolygonSymbolizer polygonSym = new PolygonSymbolizer();
        this.readGeometryElt(polygonSym, dom, symElt);
        Element dimElt = dom.getElement(symElt, "Dimensions");
        Dimensions dims = this.readDimensions(dom, dimElt);
        polygonSym.setDimensions(dims);
        Element strokeElt = dom.getElement(symElt, "Stroke");
        Stroke stroke = this.readStroke(dom, strokeElt);
        polygonSym.setStroke(stroke);
        Element fillElt = dom.getElement(symElt, "Fill");
        Fill fill = this.readFill(dom, fillElt);
        polygonSym.setFill(fill);
        return polygonSym;
    }

    public VectorSymbolizer readVector(DOMHelper dom, Element symElt) {
        VectorSymbolizer vectorSym = new VectorSymbolizer();
        this.readGeometryElt(vectorSym, dom, symElt);
        Element dirElt = dom.getElement(symElt, "Direction");
        Geometry direction = this.readGeometry(dom, dirElt);
        vectorSym.setDirection(direction);
        String dirType = dom.getAttributeValue(dirElt, "type");
        if (dirType.equalsIgnoreCase("DIFF")) {
            vectorSym.setDirectionType(VectorSymbolizer.DirectionType.DIFF);
        } else if (dirType.equalsIgnoreCase("ROT")) {
            vectorSym.setDirectionType(VectorSymbolizer.DirectionType.ROT);
        } else if (dirType.equalsIgnoreCase("ABS")) {
            vectorSym.setDirectionType(VectorSymbolizer.DirectionType.ABS);
        }
        NodeList cssElts = dom.getElements(symElt, "Direction/CssParameter");
        for (int i = 0; i < cssElts.getLength(); ++i) {
            Element cssElt = (Element)cssElts.item(i);
            String paramName = dom.getAttributeValue(cssElt, "name");
            if (paramName.equalsIgnoreCase("geometry-length")) {
                ScalarParameter lengthData = this.cssReader.readCssParameter(dom, cssElt);
                vectorSym.setLength(lengthData);
            }
            if (!paramName.equalsIgnoreCase("vector-steps")) continue;
            ScalarParameter stepData = this.cssReader.readCssParameter(dom, cssElt);
            vectorSym.setNumberOfSteps(stepData);
        }
        Element strokeElt = dom.getElement(symElt, "Stroke");
        Stroke stroke = this.readStroke(dom, strokeElt);
        vectorSym.setStroke(stroke);
        Element fillElt = dom.getElement(symElt, "Fill");
        Fill fill = this.readFill(dom, fillElt);
        vectorSym.setFill(fill);
        Element graphicElt = dom.getElement(symElt, "Graphic");
        Graphic graphic = this.readGraphic(dom, graphicElt);
        vectorSym.setGraphic(graphic);
        return vectorSym;
    }

    public TextSymbolizer readText(DOMHelper dom, Element symElt) {
        TextSymbolizer textSym = new TextSymbolizer();
        this.readGeometryElt(textSym, dom, symElt);
        Element labelElt = dom.getElement(symElt, "Label");
        ScalarParameter labelParam = this.cssReader.readCssParameter(dom, labelElt);
        textSym.setLabel(labelParam);
        Element fontElt = dom.getElement(symElt, "Font");
        Font font = this.readFont(dom, fontElt);
        textSym.setFont(font);
        Element fillElt = dom.getElement(symElt, "Fill");
        Fill fill = this.readFill(dom, fillElt);
        textSym.setFill(fill);
        return textSym;
    }

    public GridFillSymbolizer readGridFill(DOMHelper dom, Element symElt) {
        GridFillSymbolizer gridSym = new GridFillSymbolizer();
        this.readGeometryElt(gridSym, dom, symElt);
        Element dimElt = dom.getElement(symElt, "Dimensions");
        Dimensions dims = this.readDimensions(dom, dimElt);
        gridSym.setDimensions(dims);
        Element fillElt = dom.getElement(symElt, "Fill");
        Fill fill = this.readFill(dom, fillElt);
        gridSym.setFill(fill);
        return gridSym;
    }

    public GridMeshSymbolizer readGridMesh(DOMHelper dom, Element symElt) {
        GridMeshSymbolizer gridSym = new GridMeshSymbolizer();
        this.readGeometryElt(gridSym, dom, symElt);
        Element dimElt = dom.getElement(symElt, "Dimensions");
        Dimensions dims = this.readDimensions(dom, dimElt);
        gridSym.setDimensions(dims);
        Element strokeElt = dom.getElement(symElt, "Stroke");
        Stroke stroke = this.readStroke(dom, strokeElt);
        gridSym.setStroke(stroke);
        return gridSym;
    }

    public GridBorderSymbolizer readGridBorder(DOMHelper dom, Element symElt) {
        GridBorderSymbolizer gridSym = new GridBorderSymbolizer();
        this.readGeometryElt(gridSym, dom, symElt);
        Element dimElt = dom.getElement(symElt, "Dimensions");
        Dimensions dims = this.readDimensions(dom, dimElt);
        gridSym.setDimensions(dims);
        Element strokeElt = dom.getElement(symElt, "Stroke");
        Stroke stroke = this.readStroke(dom, strokeElt);
        gridSym.setStroke(stroke);
        return gridSym;
    }

    public RasterSymbolizer readRaster(DOMHelper dom, Element symElt) {
        RasterSymbolizer rasterSym = new RasterSymbolizer();
        this.readRasterParameters(rasterSym, dom, symElt);
        return rasterSym;
    }

    public void readRasterParameters(RasterSymbolizer rasterSym, DOMHelper dom, Element symElt) {
        String normColors = dom.getAttributeValue(symElt, "ChannelSelection/@normalizedColors");
        if (normColors != null && normColors.equalsIgnoreCase("true")) {
            rasterSym.setNormalizedColors(true);
        }
        Element redElt = dom.getElement(symElt, "ChannelSelection/RedChannel");
        rasterSym.setRedChannel(this.readRasterChannel(dom, redElt));
        Element greenElt = dom.getElement(symElt, "ChannelSelection/GreenChannel");
        rasterSym.setGreenChannel(this.readRasterChannel(dom, greenElt));
        Element blueElt = dom.getElement(symElt, "ChannelSelection/BlueChannel");
        rasterSym.setBlueChannel(this.readRasterChannel(dom, blueElt));
        Element alphaElt = dom.getElement(symElt, "ChannelSelection/AlphaChannel");
        rasterSym.setAlphaChannel(this.readRasterChannel(dom, alphaElt));
        Element grayElt = dom.getElement(symElt, "ChannelSelection/GrayChannel");
        rasterSym.setGrayChannel(this.readRasterChannel(dom, grayElt));
        Element opacityElt = dom.getElement(symElt, "Opacity");
        ScalarParameter opacity = this.cssReader.readCssParameter(dom, opacityElt);
        rasterSym.setOpacity(opacity);
        String rasterPoolSize = dom.getElementValue(symElt, "RasterPoolSize");
        if (rasterPoolSize != null) {
            rasterSym.setTexPoolSize(Integer.parseInt(rasterPoolSize));
        }
        Element dimElt = dom.getElement(symElt, "Dimensions");
        Dimensions dim = this.readDimensions(dom, dimElt);
        rasterSym.setRasterDimensions(dim);
    }

    public RasterChannel readRasterChannel(DOMHelper dom, Element channelElt) {
        RasterChannel channel = null;
        if (channelElt == null) {
            return null;
        }
        if (dom.existElement(channelElt, "SourceChannelName")) {
            Element channelNameElt = dom.getElement(channelElt, "SourceChannelName");
            ScalarParameter param = this.cssReader.readPropertyName(dom, channelNameElt);
            channel = new RasterChannel(param);
        } else {
            ScalarParameter param = this.cssReader.readCssParameter(dom, channelElt);
            channel = new RasterChannel(param);
        }
        if (dom.existElement(channelElt, "ContrastEhancement/Normalize")) {
            channel.setNormalize(true);
        } else if (dom.existElement(channelElt, "ContrastEhancement/Histogram")) {
            channel.setHistogram(true);
        }
        String gammaText = dom.getElementValue(channelElt, "ContrastEhancement/GammaValue");
        if (gammaText != null) {
            channel.setGamma(Double.parseDouble(gammaText));
        }
        return channel;
    }

    public TextureSymbolizer readTexture(DOMHelper dom, Element symElt) {
        TextureSymbolizer texSym = new TextureSymbolizer();
        Element gridElt = dom.getElement(symElt, "Grid");
        this.readGeometryElt(texSym, dom, gridElt);
        this.readTexCoords(texSym, dom, gridElt);
        Element dimElt = dom.getElement(gridElt, "Dimensions");
        Dimensions dim = this.readDimensions(dom, dimElt);
        texSym.setGridDimensions(dim);
        Element rasterElt = dom.getElement(symElt, "Raster");
        this.readRasterParameters(texSym, dom, rasterElt);
        return texSym;
    }

    public void readTexCoords(TextureSymbolizer texSym, DOMHelper dom, Element gridElt) {
        Geometry texCoords = texSym.getTextureCoordinates();
        Element geomElt = dom.getElement(gridElt, "Geometry");
        NodeList cssElts = dom.getElements(geomElt, "CssParameter");
        for (int i = 0; i < cssElts.getLength(); ++i) {
            Element cssElt = (Element)cssElts.item(i);
            String paramName = dom.getAttributeValue(cssElt, "name");
            if (paramName.equalsIgnoreCase("geometry-tx")) {
                ScalarParameter xData = this.cssReader.readCssParameter(dom, cssElt);
                texCoords.setX(xData);
                continue;
            }
            if (paramName.equalsIgnoreCase("geometry-ty")) {
                ScalarParameter yData = this.cssReader.readCssParameter(dom, cssElt);
                texCoords.setY(yData);
                continue;
            }
            if (!paramName.equalsIgnoreCase("geometry-tz")) continue;
            ScalarParameter zData = this.cssReader.readCssParameter(dom, cssElt);
            texCoords.setZ(zData);
        }
    }

    protected void readGeometryElt(Symbolizer symbolizer, DOMHelper dom, Element symElt) {
        Element geomElt = dom.getElement(symElt, "Geometry");
        if (geomElt != null) {
            Geometry geometry = this.readGeometry(dom, geomElt);
            symbolizer.setGeometry(geometry);
        }
    }

    public Geometry readGeometry(DOMHelper dom, Element geomElt) {
        Geometry geometry = new Geometry();
        if (dom.existElement(geomElt, "PropertyName")) {
            String propName = dom.getElementValue(geomElt, "PropertyName");
            geometry.setPropertyName(propName);
        } else {
            NodeList cssElts = dom.getElements(geomElt, "CssParameter");
            for (int i = 0; i < cssElts.getLength(); ++i) {
                Element cssElt = (Element)cssElts.item(i);
                String paramName = dom.getAttributeValue(cssElt, "name");
                if (paramName.equalsIgnoreCase("geometry-object")) {
                    ScalarParameter objectData = this.cssReader.readCssParameter(dom, cssElt);
                    geometry.setObject(objectData);
                    continue;
                }
                if (paramName.equalsIgnoreCase("geometry-breaks")) {
                    ScalarParameter breakData = this.cssReader.readCssParameter(dom, cssElt);
                    geometry.setBreaks(breakData);
                    continue;
                }
                if (paramName.equalsIgnoreCase("geometry-x")) {
                    ScalarParameter xData = this.cssReader.readCssParameter(dom, cssElt);
                    geometry.setX(xData);
                    continue;
                }
                if (paramName.equalsIgnoreCase("geometry-y")) {
                    ScalarParameter yData = this.cssReader.readCssParameter(dom, cssElt);
                    geometry.setY(yData);
                    continue;
                }
                if (paramName.equalsIgnoreCase("geometry-z")) {
                    ScalarParameter zData = this.cssReader.readCssParameter(dom, cssElt);
                    geometry.setZ(zData);
                    continue;
                }
                if (!paramName.equalsIgnoreCase("geometry-t")) continue;
                ScalarParameter tData = this.cssReader.readCssParameter(dom, cssElt);
                geometry.setT(tData);
            }
            String crs = dom.getAttributeValue(geomElt, "srsName");
            geometry.setCrs(crs);
        }
        return geometry;
    }

    public Dimensions readDimensions(DOMHelper dom, Element dimElt) {
        if (dimElt == null) {
            return null;
        }
        Dimensions dim = new Dimensions();
        NodeList axisElts = dom.getElements(dimElt, "Axis");
        for (int i = 0; i < axisElts.getLength(); ++i) {
            Element axisElt = (Element)axisElts.item(i);
            String axisName = dom.getAttributeValue(axisElt, "name");
            String axisMapping = dom.getElementValue(axisElt, "PropertyName");
            dim.put(axisName, axisMapping);
        }
        return dim;
    }

    public Graphic readGraphic(DOMHelper dom, Element graphicElt) {
        Graphic graphic = new Graphic();
        if (graphicElt == null) {
            return graphic;
        }
        if (dom.existElement(graphicElt, "Mark")) {
            GraphicMark mark = new GraphicMark();
            Element nameElt = dom.getElement(graphicElt, "Mark/WellKnownName");
            ScalarParameter shape = this.cssReader.readCssParameter(dom, nameElt);
            mark.setShape(shape);
            Element strokeElt = dom.getElement(graphicElt, "Mark/Stroke");
            Stroke stroke = this.readStroke(dom, strokeElt);
            mark.setStroke(stroke);
            Element fillElt = dom.getElement(graphicElt, "Mark/Fill");
            Fill fill = this.readFill(dom, fillElt);
            mark.setFill(fill);
            graphic.getGlyphs().add(mark);
        } else if (dom.existElement(graphicElt, "ExternalGraphic")) {
            GraphicImage img = new GraphicImage();
            img.setFormat(dom.getElementValue(graphicElt, "ExternalGraphic/Format"));
            String baseFolder = dom.getElementValue(graphicElt, "ExternalGraphic/Base");
            if (baseFolder != null) {
                img.setBaseFolder(baseFolder);
            } else {
                try {
                    URIResolver resolver = new URIResolver(new URI("./"), dom.getXmlDocument().getUri());
                    img.setBaseFolder(resolver.getResolvedUri().toString());
                }
                catch (URISyntaxException resolver) {
                    // empty catch block
                }
            }
            this.iconIdProvider.setPrefix(img.getBaseFolder());
            Element urlElt = dom.getElement(graphicElt, "ExternalGraphic/OnlineResource");
            ScalarParameter url = this.cssReader.readCssParameter(dom, urlElt, this.iconIdProvider);
            img.setUrl(url);
            graphic.getGlyphs().add(img);
        }
        Element opacityElt = dom.getElement(graphicElt, "Opacity");
        ScalarParameter opacity = this.cssReader.readCssParameter(dom, opacityElt);
        graphic.setOpacity(opacity);
        Element sizeElt = dom.getElement(graphicElt, "Size");
        ScalarParameter size = this.cssReader.readCssParameter(dom, sizeElt);
        graphic.setSize(size);
        Element rotationElt = dom.getElement(graphicElt, "Rotation");
        ScalarParameter rotation = this.cssReader.readCssParameter(dom, rotationElt);
        graphic.setRotation(rotation);
        Element spacingElt = dom.getElement(graphicElt, "Spacing");
        ScalarParameter spacing = this.cssReader.readCssParameter(dom, spacingElt);
        graphic.setSpacing(spacing);
        return graphic;
    }

    public Fill readFill(DOMHelper dom, Element fillElt) {
        Fill fill = new Fill();
        fill.setColor(new Color());
        if (fillElt == null) {
            return fill;
        }
        Element gFillElt = dom.getElement(fillElt, "GraphicFill");
        if (gFillElt != null) {
            fill.setGraphicFill(this.readGraphic(dom, gFillElt));
        }
        NodeList cssElts = dom.getElements(fillElt, "CssParameter");
        for (int i = 0; i < cssElts.getLength(); ++i) {
            Element cssElt = (Element)cssElts.item(i);
            String paramName = dom.getAttributeValue(cssElt, "name");
            if (paramName.equalsIgnoreCase("fill")) {
                String colorVal = dom.getElementValue(cssElt, "");
                fill.setColor(new Color(colorVal.substring(1)));
                continue;
            }
            if (paramName.equalsIgnoreCase("fill-red")) {
                ScalarParameter red = this.cssReader.readCssParameter(dom, cssElt);
                fill.getColor().setRed(red);
                continue;
            }
            if (paramName.equalsIgnoreCase("fill-green")) {
                ScalarParameter green = this.cssReader.readCssParameter(dom, cssElt);
                fill.getColor().setGreen(green);
                continue;
            }
            if (paramName.equalsIgnoreCase("fill-blue")) {
                ScalarParameter blue = this.cssReader.readCssParameter(dom, cssElt);
                fill.getColor().setBlue(blue);
                continue;
            }
            if (!paramName.equalsIgnoreCase("fill-opacity")) continue;
            ScalarParameter opacity = this.cssReader.readCssParameter(dom, cssElt);
            fill.setOpacity(opacity);
            fill.getColor().setAlpha(opacity);
        }
        return fill;
    }

    public Stroke readStroke(DOMHelper dom, Element strokeElt) {
        Element gStrokeElt;
        Stroke stroke = new Stroke();
        stroke.setColor(new Color());
        if (strokeElt == null) {
            return stroke;
        }
        Element gFillElt = dom.getElement(strokeElt, "GraphicFill");
        if (gFillElt != null) {
            stroke.setGraphicFill(this.readGraphic(dom, gFillElt));
        }
        if ((gStrokeElt = dom.getElement(strokeElt, "GraphicStroke")) != null) {
            stroke.setGraphicStroke(this.readGraphic(dom, gStrokeElt));
        }
        NodeList cssElts = dom.getElements(strokeElt, "CssParameter");
        for (int i = 0; i < cssElts.getLength(); ++i) {
            ScalarParameter smooth;
            Element cssElt = (Element)cssElts.item(i);
            String paramName = dom.getAttributeValue(cssElt, "name");
            if (paramName.equalsIgnoreCase("stroke")) {
                String colorVal = dom.getElementValue(cssElt, "");
                stroke.setColor(new Color(colorVal.substring(1)));
                continue;
            }
            if (paramName.equalsIgnoreCase("stroke-red")) {
                ScalarParameter red = this.cssReader.readCssParameter(dom, cssElt);
                stroke.getColor().setRed(red);
                continue;
            }
            if (paramName.equalsIgnoreCase("stroke-green")) {
                ScalarParameter green = this.cssReader.readCssParameter(dom, cssElt);
                stroke.getColor().setGreen(green);
                continue;
            }
            if (paramName.equalsIgnoreCase("stroke-blue")) {
                ScalarParameter blue = this.cssReader.readCssParameter(dom, cssElt);
                stroke.getColor().setBlue(blue);
                continue;
            }
            if (paramName.equalsIgnoreCase("stroke-opacity")) {
                ScalarParameter opacity = this.cssReader.readCssParameter(dom, cssElt);
                stroke.setOpacity(opacity);
                stroke.getColor().setAlpha(opacity);
                continue;
            }
            if (paramName.equalsIgnoreCase("stroke-width")) {
                ScalarParameter width = this.cssReader.readCssParameter(dom, cssElt);
                stroke.setWidth(width);
                continue;
            }
            if (paramName.equalsIgnoreCase("stroke-linejoin")) {
                ScalarParameter linejoin = this.cssReader.readCssParameter(dom, cssElt);
                stroke.setLinejoin(linejoin);
                continue;
            }
            if (paramName.equalsIgnoreCase("stroke-linecap")) {
                ScalarParameter linecap = this.cssReader.readCssParameter(dom, cssElt);
                stroke.setLinecap(linecap);
                continue;
            }
            if (paramName.equalsIgnoreCase("stroke-dasharray")) {
                ScalarParameter dasharray = this.cssReader.readCssParameter(dom, cssElt);
                stroke.setDasharray(dasharray);
                continue;
            }
            if (paramName.equalsIgnoreCase("stroke-dashoffset")) {
                ScalarParameter dashoffset = this.cssReader.readCssParameter(dom, cssElt);
                stroke.setDashoffset(dashoffset);
                continue;
            }
            if (!paramName.equalsIgnoreCase("stroke-smooth") || !((String)(smooth = this.cssReader.readCssParameter(dom, cssElt)).getValue()).equals("true")) continue;
            stroke.setSmooth(true);
        }
        return stroke;
    }

    public Font readFont(DOMHelper dom, Element fontElt) {
        Font font = new Font();
        if (fontElt == null) {
            return font;
        }
        NodeList cssElts = dom.getElements(fontElt, "CssParameter");
        for (int i = 0; i < cssElts.getLength(); ++i) {
            Element cssElt = (Element)cssElts.item(i);
            String paramName = dom.getAttributeValue(cssElt, "name");
            if (paramName.equalsIgnoreCase("font-family")) {
                ScalarParameter family = this.cssReader.readCssParameter(dom, cssElt);
                font.setFamily(family);
                continue;
            }
            if (paramName.equalsIgnoreCase("font-style")) {
                ScalarParameter style = this.cssReader.readCssParameter(dom, cssElt);
                font.setStyle(style);
                continue;
            }
            if (paramName.equalsIgnoreCase("font-weight")) {
                ScalarParameter weight = this.cssReader.readCssParameter(dom, cssElt);
                font.setWeight(weight);
                continue;
            }
            if (!paramName.equalsIgnoreCase("font-size")) continue;
            ScalarParameter size = this.cssReader.readCssParameter(dom, cssElt);
            font.setSize(size);
        }
        return font;
    }
}

