/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sld.functions;

import java.util.Hashtable;
import org.vast.ows.sld.functions.AbstractMappingFunction;

public class CategoryLookUpTable
extends AbstractMappingFunction {
    protected Hashtable<String, Double> mappingTable;
    protected double defaultValue = Double.NaN;

    public CategoryLookUpTable() {
        this.mappingTable = new Hashtable();
    }

    @Override
    public double compute(String indexVal) {
        Double val = this.mappingTable.get(indexVal);
        if (val != null) {
            return val;
        }
        return this.defaultValue;
    }

    @Override
    public boolean hasCategoricalInput() {
        return true;
    }

    public Hashtable<String, Double> getMappingTable() {
        return this.mappingTable;
    }

    public void addMapping(String text, double val) {
        this.mappingTable.put(text, val);
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(double defaultValue) {
        this.defaultValue = defaultValue;
    }
}

