/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sld.functions;

import org.vast.ows.sld.MappingFunction;
import org.vast.ows.sld.functions.CategoryLookUpTable;
import org.vast.ows.sld.functions.DirectLookUpTable;
import org.vast.ows.sld.functions.LinearAdjustment;
import org.vast.ows.sld.functions.LookUpTable0D;
import org.vast.ows.sld.functions.LookUpTable1D;
import org.vast.ows.sld.functions.StringIdProvider;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FunctionReader {
    public MappingFunction readFunction(DOMHelper dom, Element functionElt, StringIdProvider stringIdProvider) {
        String functionType = functionElt.getLocalName();
        MappingFunction func = null;
        if (functionType.equalsIgnoreCase("LinearAdjustment")) {
            func = this.readLinearAdjustment(dom, functionElt);
        } else if (functionType.equalsIgnoreCase("DirectLookUpTable")) {
            func = this.readDirectTable(dom, functionElt, stringIdProvider);
        } else if (functionType.equalsIgnoreCase("CategoryLookUpTable")) {
            func = this.readCategoryTable(dom, functionElt, stringIdProvider);
        } else if (functionType.equalsIgnoreCase("LookUpTable0D")) {
            func = this.readLUT0D(dom, functionElt, stringIdProvider);
        } else if (functionType.equalsIgnoreCase("LookUpTable1D")) {
            func = this.readLUT1D(dom, functionElt);
        }
        return func;
    }

    public MappingFunction readLinearAdjustment(DOMHelper dom, Element lutElt) {
        String offVal;
        double gain = 1.0;
        double offset = 0.0;
        String gainVal = dom.getElementValue(lutElt, "Gain");
        if (gainVal != null) {
            gain = Double.parseDouble(gainVal);
        }
        if ((offVal = dom.getElementValue(lutElt, "Offset")) != null) {
            offset = Double.parseDouble(offVal);
        }
        LinearAdjustment function = new LinearAdjustment(gain, offset);
        return function;
    }

    public MappingFunction readDirectTable(DOMHelper dom, Element lutElt, StringIdProvider stringIdProvider) {
        int i;
        String[] tableValues = dom.getElementValue(lutElt, "TableValues").split(" ");
        double[] tableData = new double[tableValues.length];
        if (stringIdProvider == null) {
            for (i = 0; i < tableValues.length; ++i) {
                tableData[i] = Double.parseDouble(tableValues[i]);
            }
        } else {
            for (i = 0; i < tableValues.length; ++i) {
                tableData[i] = stringIdProvider.getStringId(tableValues[i]);
            }
        }
        DirectLookUpTable function = new DirectLookUpTable(tableData);
        return function;
    }

    public MappingFunction readCategoryTable(DOMHelper dom, Element tableElt, StringIdProvider stringIdProvider) {
        CategoryLookUpTable function = new CategoryLookUpTable();
        String defValue = dom.getElementValue(tableElt, "Default");
        if (stringIdProvider != null) {
            function.setDefaultValue(stringIdProvider.getStringId(defValue));
        } else {
            function.setDefaultValue(Double.parseDouble(defValue));
        }
        NodeList mapElts = dom.getElements(tableElt, "Mapping");
        for (int i = 0; i < mapElts.getLength(); ++i) {
            Element nextMapping = (Element)mapElts.item(i);
            String key = dom.getAttributeValue(nextMapping, "@key");
            String val = dom.getElementValue(nextMapping);
            if (stringIdProvider != null) {
                function.addMapping(key, stringIdProvider.getStringId(val));
                continue;
            }
            function.addMapping(key, Double.parseDouble(val));
        }
        return function;
    }

    public MappingFunction readLUT0D(DOMHelper dom, Element lutElt, StringIdProvider stringIdProvider) {
        Element valuesElt = dom.getElement(lutElt, "TableValues");
        double[][] tableData = this.parseTableValues(dom, valuesElt, stringIdProvider);
        LookUpTable0D function = new LookUpTable0D(tableData);
        return function;
    }

    public MappingFunction readLUT1D(DOMHelper dom, Element lutElt) {
        Element valuesElt = dom.getElement(lutElt, "TableValues");
        double[][] tableData = this.parseTableValues(dom, valuesElt, null);
        LookUpTable1D function = new LookUpTable1D(tableData);
        return function;
    }

    private double[][] parseTableValues(DOMHelper dom, Element valuesElt, StringIdProvider stringIdProvider) {
        String values = dom.getElementValue(valuesElt);
        String[] valueTable = values.split(" ");
        int tupleCount = valueTable.length / 2;
        double[][] tableData = new double[2][tupleCount];
        for (int i = 0; i < tupleCount; ++i) {
            String srcVal = valueTable[2 * i];
            tableData[0][i] = Double.parseDouble(srcVal);
            String destVal = valueTable[2 * i + 1];
            tableData[1][i] = stringIdProvider != null ? (double)stringIdProvider.getStringId(destVal) : Double.parseDouble(destVal);
        }
        return tableData;
    }
}

