/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sld.functions;

import org.vast.ows.sld.functions.AbstractMappingFunction;

public class LookUpTable0D
extends AbstractMappingFunction {
    protected double[][] tableData;

    public LookUpTable0D(double[][] tableData) {
        this.tableData = tableData;
    }

    @Override
    public double compute(double indexVal) {
        if (this.tableData == null) {
            return 0.0;
        }
        int maxi = this.tableData[0].length - 1;
        if (indexVal >= this.tableData[0][maxi]) {
            return this.tableData[1][maxi];
        }
        if (indexVal <= this.tableData[0][0]) {
            return this.tableData[1][0];
        }
        int nextIndex = 0;
        double tableVal = this.tableData[0][nextIndex];
        while (indexVal > tableVal) {
            tableVal = this.tableData[0][++nextIndex];
        }
        if (indexVal == tableVal) {
            return this.tableData[1][nextIndex];
        }
        int prevIndex = nextIndex - 1;
        double prevInVal = this.tableData[0][prevIndex];
        double nextInVal = this.tableData[0][nextIndex];
        double a = (indexVal - prevInVal) / (nextInVal - prevInVal);
        double prevOutVal = this.tableData[1][prevIndex];
        double nextOutVal = this.tableData[1][nextIndex];
        return prevOutVal + a * (nextOutVal - prevOutVal);
    }

    public double[][] getTableData() {
        return this.tableData;
    }

    public void setTableData(double[][] tableData) {
        this.tableData = tableData;
    }
}

