/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sos;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import net.opengis.swe.v20.DataChoice;
import net.opengis.swe.v20.DataComponent;
import net.opengis.swe.v20.DataComponentVisitor;
import net.opengis.swe.v20.DataRecord;
import net.opengis.swe.v20.SimpleComponent;
import net.opengis.swe.v20.Vector;
import org.vast.data.BaseTreeVisitor;

public class DataStructFilter
extends BaseTreeVisitor {
    HashSet<String> selectedObsProperties = new HashSet();

    public DataStructFilter(Collection<String> selectedObsProperties) {
        this.selectedObsProperties.addAll(selectedObsProperties);
    }

    public void visit(DataRecord record) {
        Iterator it = record.getFieldList().iterator();
        this.filterChildren(record.getDefinition(), it);
    }

    public void visit(Vector vect) {
        Iterator it = vect.getCoordinateList().iterator();
        this.filterChildren(vect.getDefinition(), it);
    }

    public void visit(DataChoice choice) {
        Iterator it = choice.getItemList().iterator();
        this.filterChildren(choice.getDefinition(), it);
    }

    protected void filterChildren(String parentDef, Iterator<? extends DataComponent> it) {
        if (parentDef == null || this.selectedObsProperties.contains(parentDef)) {
            return;
        }
        while (it.hasNext()) {
            DataComponent child = it.next();
            String defUri = child.getDefinition();
            if (defUri != null && !this.selectedObsProperties.contains(defUri)) {
                it.remove();
                continue;
            }
            child.accept((DataComponentVisitor)this);
            if (child instanceof SimpleComponent || child.getComponentCount() != 0) continue;
            it.remove();
        }
    }
}

