/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sos;

import java.util.Map;
import net.opengis.fes.v20.BinarySpatialOp;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.fes.FESUtils;
import org.vast.ows.sos.GetFeatureOfInterestRequest;
import org.vast.ows.sos.SOSException;
import org.vast.ows.swe.SWERequestReader;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GetFoiReaderV20
extends SWERequestReader<GetFeatureOfInterestRequest> {
    protected FESUtils fesUtils = new FESUtils("2.0");

    @Override
    public GetFeatureOfInterestRequest readURLParameters(Map<String, String> queryParameters) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport("1.1.0");
        GetFeatureOfInterestRequest request = new GetFeatureOfInterestRequest();
        this.readCommonQueryArguments(queryParameters, request);
        Map<String, String> namespaceMap = null;
        String nsList = queryParameters.remove("namespaces");
        if (nsList != null) {
            namespaceMap = this.fesUtils.readKVPNamespaces(nsList);
        }
        for (Map.Entry<String, String> item : queryParameters.entrySet()) {
            String argName = item.getKey();
            String argValue = item.getValue();
            if (argName.equalsIgnoreCase("procedure")) {
                request.getProcedures().clear();
                for (String proc : argValue.split(",")) {
                    request.getProcedures().add(proc);
                }
                continue;
            }
            if (argName.equalsIgnoreCase("observedProperty")) {
                request.getObservables().clear();
                for (String obs : argValue.split(",")) {
                    request.getObservables().add(obs);
                }
                continue;
            }
            if (argName.equalsIgnoreCase("featureOfInterest")) {
                request.getFoiIDs().clear();
                for (String foi : argValue.split(",")) {
                    request.getFoiIDs().add(foi);
                }
                continue;
            }
            if (argName.equalsIgnoreCase("spatialFilter")) {
                try {
                    BinarySpatialOp filter = this.fesUtils.readKVPSpatialFilter(argValue, namespaceMap);
                    request.setSpatialFilter(filter);
                    continue;
                }
                catch (Exception e) {
                    throw new SOSException("InvalidParameterValue", "spatialFilter", null, null);
                }
            }
            if (argValue == null) {
                argValue = "";
            }
            this.addKVPExtension(argName, argValue, request);
        }
        this.checkParameters(request, report);
        return request;
    }

    @Override
    public GetFeatureOfInterestRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport("1.1.0");
        GetFeatureOfInterestRequest request = new GetFeatureOfInterestRequest();
        GetFoiReaderV20.readCommonXML(dom, requestElt, request);
        NodeList procList = dom.getElements(requestElt, "procedure");
        for (int i = 0; i < procList.getLength(); ++i) {
            String val = dom.getElementValue((Element)procList.item(i));
            request.getProcedures().add(val);
        }
        NodeList obsList = dom.getElements(requestElt, "observedProperty");
        for (int i = 0; i < obsList.getLength(); ++i) {
            String val = dom.getElementValue((Element)obsList.item(i));
            request.getObservables().add(val);
        }
        NodeList foiList = dom.getElements(requestElt, "featureOfInterest");
        for (int i = 0; i < foiList.getLength(); ++i) {
            String val = dom.getElementValue((Element)foiList.item(i));
            request.getFoiIDs().add(val);
        }
        try {
            Element spatialOpElt = dom.getElement(requestElt, "spatialFilter/*");
            if (spatialOpElt != null) {
                BinarySpatialOp filter = this.fesUtils.readXMLSpatialFilter(spatialOpElt);
                request.setSpatialFilter(filter);
            }
        }
        catch (Exception e) {
            throw new SOSException("InvalidParameterValue", "spatialFilter", null, null);
        }
        this.checkParameters(request, report);
        return request;
    }

    protected void checkParameters(GetFeatureOfInterestRequest request, OWSExceptionReport report) throws OWSException {
        SWERequestReader.checkParameters(request, report, "SOS");
        report.process();
    }
}

