/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sos;

import java.util.LinkedHashMap;
import java.util.Map;
import org.vast.ogc.OGCRegistry;
import org.vast.ows.OWSException;
import org.vast.ows.OWSRequest;
import org.vast.ows.fes.FESUtils;
import org.vast.ows.sos.GetFeatureOfInterestRequest;
import org.vast.ows.sos.SOSException;
import org.vast.ows.swe.SWERequestWriter;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GetFoiWriterV20
extends SWERequestWriter<GetFeatureOfInterestRequest> {
    protected FESUtils fesUtils = new FESUtils("2.0");

    @Override
    public Map<String, String> buildURLParameters(GetFeatureOfInterestRequest request) throws OWSException {
        StringBuilder buf;
        LinkedHashMap<String, String> urlParams = new LinkedHashMap<String, String>();
        this.addCommonArgs(urlParams, (OWSRequest)request);
        if (!request.getProcedures().isEmpty()) {
            buf = new StringBuilder();
            for (String off : request.getProcedures()) {
                buf.append(off);
                buf.append(',');
            }
            buf.deleteCharAt(buf.length() - 1);
            urlParams.put("procedure", buf.toString());
        }
        if (!request.getObservables().isEmpty()) {
            buf = new StringBuilder();
            for (String off : request.getObservables()) {
                buf.append(off);
                buf.append(',');
            }
            buf.deleteCharAt(buf.length() - 1);
            urlParams.put("observedProperty", buf.toString());
        }
        if (!request.getFoiIDs().isEmpty()) {
            buf = new StringBuilder();
            for (String off : request.getFoiIDs()) {
                buf.append(off);
                buf.append(',');
            }
            buf.deleteCharAt(buf.length() - 1);
            urlParams.put("featureOfInterest", buf.toString());
        }
        if (request.getSpatialFilter() != null && !request.getBbox().isNull()) {
            buf = new StringBuilder();
            buf.append(request.getSpatialFilter().getOperand1().toString());
            buf.append(',');
            this.writeBboxArgument(buf, request.getBbox(), true);
            urlParams.put("spatialFilter", buf.toString());
        }
        return urlParams;
    }

    @Override
    public Element buildXMLQuery(DOMHelper dom, GetFeatureOfInterestRequest request) throws OWSException {
        dom.addUserPrefix("sos", OGCRegistry.getNamespaceURI((String)"SOS", (String)request.getVersion()));
        dom.addUserPrefix("ogc", OGCRegistry.getNamespaceURI((String)"OGC"));
        this.fesUtils.resetIdCounters();
        Element rootElt = dom.createElement("sos:GetFeatureOfInterest");
        this.addCommonXML(dom, rootElt, request);
        for (String proc : request.getProcedures()) {
            dom.setElementValue(rootElt, "+sos:procedure", proc);
        }
        for (String obs : request.getObservables()) {
            dom.setElementValue(rootElt, "+sos:observedProperty", obs);
        }
        for (String foi : request.getFoiIDs()) {
            dom.setElementValue(rootElt, "+sos:featureOfInterest", foi);
        }
        if (request.getSpatialFilter() != null) {
            try {
                Element propElt = dom.addElement((Node)rootElt, "sos:spatialFilter");
                Element filterElt = this.fesUtils.writeSpatialFilter(dom, request.getSpatialFilter());
                propElt.appendChild(filterElt);
            }
            catch (Exception e) {
                throw new SOSException("Error while writing spatial filter", e);
            }
        }
        return rootElt;
    }
}

