/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sos;

import java.util.ArrayList;
import java.util.List;
import net.opengis.fes.v20.BinarySpatialOp;
import net.opengis.fes.v20.BinaryTemporalOp;
import org.vast.ogc.OGCRegistry;
import org.vast.ogc.om.OMUtils;
import org.vast.ows.OWSRequest;
import org.vast.ows.fes.FESRequestUtils;
import org.vast.util.Bbox;
import org.vast.util.TimeExtent;

public class GetObservationRequest
extends OWSRequest {
    public static String DEFAULT_FORMAT = OGCRegistry.getNamespaceURI((String)OMUtils.OM, (String)"2.0");
    protected List<String> procedures;
    protected List<String> offerings;
    protected List<String> observables;
    protected List<String> foiIDs;
    protected BinaryTemporalOp temporalFilter;
    protected BinarySpatialOp spatialFilter;
    protected String format;
    protected String resultModel;
    protected ResponseMode responseMode;

    public GetObservationRequest() {
        this.service = "SOS";
        this.operation = "GetObservation";
        this.procedures = new ArrayList<String>(2);
        this.offerings = new ArrayList<String>(2);
        this.observables = new ArrayList<String>(2);
        this.foiIDs = new ArrayList<String>(2);
    }

    public String getOffering() {
        if (this.offerings.size() == 0) {
            return null;
        }
        return this.offerings.get(0);
    }

    public void setOffering(String offering) {
        this.offerings.add(offering);
    }

    public List<String> getOfferings() {
        return this.offerings;
    }

    public List<String> getObservables() {
        return this.observables;
    }

    public List<String> getProcedures() {
        return this.procedures;
    }

    public List<String> getFoiIDs() {
        return this.foiIDs;
    }

    public BinaryTemporalOp getTemporalFilter() {
        return this.temporalFilter;
    }

    public void setTemporalFilter(BinaryTemporalOp temporalFilter) {
        this.temporalFilter = temporalFilter;
    }

    public TimeExtent getTime() {
        return FESRequestUtils.filterToTimeExtent(this.temporalFilter);
    }

    public void setTime(TimeExtent time) {
        this.temporalFilter = FESRequestUtils.timeExtentToFilter(time);
    }

    public BinarySpatialOp getSpatialFilter() {
        return this.spatialFilter;
    }

    public void setSpatialFilter(BinarySpatialOp spatialFilter) {
        this.spatialFilter = spatialFilter;
    }

    public Bbox getBbox() {
        return FESRequestUtils.filterToBbox(this.spatialFilter);
    }

    public void setBbox(Bbox bbox) {
        this.spatialFilter = FESRequestUtils.bboxToFilter(bbox);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public ResponseMode getResponseMode() {
        return this.responseMode;
    }

    public void setResponseMode(ResponseMode responseMode) {
        this.responseMode = responseMode;
    }

    public String getResultModel() {
        return this.resultModel;
    }

    public void setResultModel(String resultModel) {
        this.resultModel = resultModel;
    }

    public static enum ResponseMode {
        INLINE,
        ATTACHED,
        OUT_OF_BAND,
        RESULT_TEMPLATE,
        RESULT_ONLY;

    }
}

