/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sos;

import java.util.LinkedHashMap;
import java.util.Map;
import org.vast.ogc.OGCRegistry;
import org.vast.ows.OWSException;
import org.vast.ows.OWSRequest;
import org.vast.ows.fes.FESUtils;
import org.vast.ows.sos.GetObservationRequest;
import org.vast.ows.sos.SOSException;
import org.vast.ows.swe.SWERequestWriter;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GetObservationWriterV20
extends SWERequestWriter<GetObservationRequest> {
    protected FESUtils fesUtils = new FESUtils("2.0");

    @Override
    public Map<String, String> buildURLParameters(GetObservationRequest request) throws OWSException {
        StringBuilder buf;
        LinkedHashMap<String, String> urlParams = new LinkedHashMap<String, String>();
        this.addCommonArgs(urlParams, (OWSRequest)request);
        if (!request.getOfferings().isEmpty()) {
            buf = new StringBuilder();
            for (String off : request.getOfferings()) {
                buf.append(off);
                buf.append(',');
            }
            buf.deleteCharAt(buf.length() - 1);
            urlParams.put("offering", buf.toString());
        }
        if (!request.getObservables().isEmpty()) {
            buf = new StringBuilder();
            for (String off : request.getObservables()) {
                buf.append(off);
                buf.append(',');
            }
            buf.deleteCharAt(buf.length() - 1);
            urlParams.put("observedProperty", buf.toString());
        }
        if (!request.getProcedures().isEmpty()) {
            buf = new StringBuilder();
            for (String off : request.getProcedures()) {
                buf.append(off);
                buf.append(',');
            }
            buf.deleteCharAt(buf.length() - 1);
            urlParams.put("procedure", buf.toString());
        }
        if (!request.getFoiIDs().isEmpty()) {
            buf = new StringBuilder();
            for (String off : request.getFoiIDs()) {
                buf.append(off);
                buf.append(',');
            }
            buf.deleteCharAt(buf.length() - 1);
            urlParams.put("featureOfInterest", buf.toString());
        }
        if (request.getTemporalFilter() != null && !request.getTime().isNull()) {
            buf = new StringBuilder();
            buf.append(request.getTemporalFilter().getOperand1().toString());
            buf.append(',');
            this.writeTimeArgument(buf, request.getTime());
            urlParams.put("temporalfilter", buf.toString());
        }
        if (request.getSpatialFilter() != null && !request.getBbox().isNull()) {
            buf = new StringBuilder();
            buf.append(request.getSpatialFilter().getOperand1().toString());
            buf.append(',');
            this.writeBboxArgument(buf, request.getBbox(), true);
            urlParams.put("spatialFilter", buf.toString());
        }
        if (request.getFormat() != null) {
            urlParams.put("responseFormat", request.getFormat());
        }
        return urlParams;
    }

    @Override
    public Element buildXMLQuery(DOMHelper dom, GetObservationRequest request) throws OWSException {
        Element filterElt;
        Element propElt;
        dom.addUserPrefix("sos", OGCRegistry.getNamespaceURI((String)"SOS", (String)request.getVersion()));
        dom.addUserPrefix("ogc", OGCRegistry.getNamespaceURI((String)"OGC"));
        this.fesUtils.resetIdCounters();
        Element rootElt = dom.createElement("sos:GetObservation");
        this.addCommonXML(dom, rootElt, request);
        for (String proc : request.getProcedures()) {
            dom.setElementValue(rootElt, "+sos:procedure", proc);
        }
        for (String off : request.getOfferings()) {
            dom.setElementValue(rootElt, "+sos:offering", off);
        }
        for (String obs : request.getObservables()) {
            dom.setElementValue(rootElt, "+sos:observedProperty", obs);
        }
        if (request.getTemporalFilter() != null) {
            try {
                propElt = dom.addElement((Node)rootElt, "sos:temporalFilter");
                filterElt = this.fesUtils.writeTemporalFilter(dom, request.getTemporalFilter());
                propElt.appendChild(filterElt);
            }
            catch (Exception e) {
                throw new SOSException("Error while writing temporal filter", e);
            }
        }
        for (String foi : request.getFoiIDs()) {
            dom.setElementValue(rootElt, "+sos:featureOfInterest", foi);
        }
        if (request.getSpatialFilter() != null) {
            try {
                propElt = dom.addElement((Node)rootElt, "sos:spatialFilter");
                filterElt = this.fesUtils.writeSpatialFilter(dom, request.getSpatialFilter());
                propElt.appendChild(filterElt);
            }
            catch (Exception e) {
                throw new SOSException("Error while writing spatial filter", e);
            }
        }
        if (request.getFormat() != null) {
            dom.setElementValue(rootElt, "sos:responseFormat", request.getFormat());
        }
        return rootElt;
    }
}

