/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sos;

import java.util.Map;
import net.opengis.fes.v20.BinarySpatialOp;
import net.opengis.fes.v20.BinaryTemporalOp;
import net.opengis.fes.v20.FilterPredicate;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.fes.FESUtils;
import org.vast.ows.sos.GetResultRequest;
import org.vast.ows.sos.SOSException;
import org.vast.ows.swe.SWERequestReader;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GetResultReaderV20
extends SWERequestReader<GetResultRequest> {
    protected FESUtils fesUtils = new FESUtils("2.0");

    @Override
    public GetResultRequest readURLParameters(Map<String, String> queryParameters) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport("1.1.0");
        GetResultRequest request = new GetResultRequest();
        this.readCommonQueryArguments(queryParameters, request);
        Map<String, String> namespaceMap = null;
        String nsList = queryParameters.remove("namespaces");
        if (nsList != null) {
            namespaceMap = this.fesUtils.readKVPNamespaces(nsList);
        }
        for (Map.Entry<String, String> item : queryParameters.entrySet()) {
            FilterPredicate filter;
            String argName = item.getKey();
            String argValue = item.getValue();
            if (argName.equalsIgnoreCase("offering")) {
                request.setOffering(argValue);
                continue;
            }
            if (argName.equalsIgnoreCase("observedProperty")) {
                request.getObservables().clear();
                for (String obs : argValue.split(",")) {
                    request.getObservables().add(obs);
                }
                continue;
            }
            if (argName.equalsIgnoreCase("featureOfInterest")) {
                request.getFoiIDs().clear();
                for (String foi : argValue.split(",")) {
                    request.getFoiIDs().add(foi);
                }
                continue;
            }
            if (argName.equalsIgnoreCase("temporalFilter")) {
                try {
                    filter = this.fesUtils.readKVPTemporalFilter(argValue, namespaceMap);
                    request.setTemporalFilter((BinaryTemporalOp)filter);
                    continue;
                }
                catch (Exception e) {
                    throw new SOSException("InvalidParameterValue", "temporalFilter", null, null);
                }
            }
            if (argName.equalsIgnoreCase("spatialFilter")) {
                try {
                    filter = this.fesUtils.readKVPSpatialFilter(argValue, namespaceMap);
                    request.setSpatialFilter((BinarySpatialOp)filter);
                    continue;
                }
                catch (Exception e) {
                    throw new SOSException("InvalidParameterValue", "spatialFilter", null, null);
                }
            }
            if (argName.equalsIgnoreCase("xmlWrapper")) {
                try {
                    request.setXmlWrapper(Boolean.parseBoolean(argValue));
                    continue;
                }
                catch (Exception e) {
                    throw new SOSException("InvalidParameterValue", "xmlWrapper", argValue, null);
                }
            }
            if (argName.equalsIgnoreCase("responseFormat")) {
                request.setFormat(argValue);
                continue;
            }
            if (argValue == null) {
                argValue = "";
            }
            this.addKVPExtension(argName, argValue, request);
        }
        this.checkParameters(request, report);
        return request;
    }

    @Override
    public GetResultRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport("1.1.0");
        GetResultRequest request = new GetResultRequest();
        GetResultReaderV20.readCommonXML(dom, requestElt, request);
        String val = dom.getElementValue(requestElt, "offering");
        request.setOffering(val);
        NodeList obsList = dom.getElements(requestElt, "observedProperty");
        for (int i = 0; i < obsList.getLength(); ++i) {
            val = dom.getElementValue((Element)obsList.item(i));
            request.getObservables().add(val);
        }
        try {
            Element timeOpElt = dom.getElement(requestElt, "temporalFilter/*");
            if (timeOpElt != null) {
                BinaryTemporalOp filter = this.fesUtils.readXMLTemporalFilter(timeOpElt);
                request.setTemporalFilter(filter);
            }
        }
        catch (Exception e) {
            throw new SOSException("InvalidParameterValue", "temporalFilter", null, null);
        }
        NodeList foiList = dom.getElements(requestElt, "featureOfInterest");
        for (int i = 0; i < foiList.getLength(); ++i) {
            val = dom.getElementValue((Element)foiList.item(i));
            request.getFoiIDs().add(val);
        }
        try {
            Element spatialOpElt = dom.getElement(requestElt, "spatialFilter/*");
            if (spatialOpElt != null) {
                BinarySpatialOp filter = this.fesUtils.readXMLSpatialFilter(spatialOpElt);
                request.setSpatialFilter(filter);
            }
        }
        catch (Exception e) {
            throw new SOSException("InvalidParameterValue", "spatialFilter", null, null);
        }
        String resFormat = dom.getElementValue(requestElt, "responseFormat");
        request.setFormat(resFormat);
        this.checkParameters(request, report);
        return request;
    }

    protected void checkParameters(GetResultRequest request, OWSExceptionReport report) throws OWSException {
        SWERequestReader.checkParameters(request, report, "SOS");
        if (request.getOffering() == null) {
            report.add(new OWSException("MissingParameterValue", "offering"));
        }
        if (request.getObservables().size() < 1) {
            report.add(new OWSException("MissingParameterValue", "observedProperty"));
        }
        report.process();
    }
}

