/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sos;

import java.util.ArrayList;
import java.util.List;
import net.opengis.fes.v20.BinarySpatialOp;
import net.opengis.fes.v20.BinaryTemporalOp;
import org.vast.ows.OWSRequest;
import org.vast.ows.fes.FESRequestUtils;
import org.vast.util.Bbox;
import org.vast.util.TimeExtent;

public class GetResultRequest
extends OWSRequest {
    protected String offering;
    protected List<String> procedures;
    protected List<String> observables;
    protected List<String> foiIDs;
    protected BinaryTemporalOp temporalFilter;
    protected BinarySpatialOp spatialFilter;
    protected String format;
    protected boolean xmlWrapper;

    public GetResultRequest() {
        this.service = "SOS";
        this.operation = "GetResult";
        this.procedures = new ArrayList<String>(2);
        this.observables = new ArrayList<String>(2);
        this.foiIDs = new ArrayList<String>(2);
    }

    public String getOffering() {
        return this.offering;
    }

    public void setOffering(String offering) {
        this.offering = offering;
    }

    public List<String> getProcedures() {
        return this.procedures;
    }

    public void setProcedures(List<String> procedures) {
        this.procedures = procedures;
    }

    public List<String> getObservables() {
        return this.observables;
    }

    public void setObservables(List<String> observables) {
        this.observables = observables;
    }

    public List<String> getFoiIDs() {
        return this.foiIDs;
    }

    public void setFoiIDs(List<String> foiIDs) {
        this.foiIDs = foiIDs;
    }

    public BinaryTemporalOp getTemporalFilter() {
        return this.temporalFilter;
    }

    public void setTemporalFilter(BinaryTemporalOp temporalFilter) {
        this.temporalFilter = temporalFilter;
    }

    public TimeExtent getTime() {
        return FESRequestUtils.filterToTimeExtent(this.temporalFilter);
    }

    public void setTime(TimeExtent time) {
        this.temporalFilter = FESRequestUtils.timeExtentToFilter(time);
    }

    public BinarySpatialOp getSpatialFilter() {
        return this.spatialFilter;
    }

    public void setSpatialFilter(BinarySpatialOp spatialFilter) {
        this.spatialFilter = spatialFilter;
    }

    public Bbox getBbox() {
        return FESRequestUtils.filterToBbox(this.spatialFilter);
    }

    public void setBbox(Bbox bbox) {
        this.spatialFilter = FESRequestUtils.bboxToFilter(bbox);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public boolean isXmlWrapper() {
        return this.xmlWrapper;
    }

    public void setXmlWrapper(boolean xmlWrapper) {
        this.xmlWrapper = xmlWrapper;
    }
}

