/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sos;

import java.util.Map;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.sos.GetResultTemplateRequest;
import org.vast.ows.swe.SWERequestReader;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GetResultTemplateReaderV20
extends SWERequestReader<GetResultTemplateRequest> {
    @Override
    public GetResultTemplateRequest readURLParameters(Map<String, String> queryParameters) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport("1.1.0");
        GetResultTemplateRequest request = new GetResultTemplateRequest();
        this.readCommonQueryArguments(queryParameters, request);
        for (Map.Entry<String, String> item : queryParameters.entrySet()) {
            String argName = item.getKey();
            String argValue = item.getValue();
            if (argName.equalsIgnoreCase("offering")) {
                request.setOffering(argValue);
                continue;
            }
            if (argName.equalsIgnoreCase("observedProperty")) {
                request.getObservables().clear();
                for (String obs : argValue.split(",")) {
                    request.getObservables().add(obs);
                }
                continue;
            }
            if (argValue == null) {
                argValue = "";
            }
            this.addKVPExtension(argName, argValue, request);
        }
        this.checkParameters(request, report);
        return request;
    }

    @Override
    public GetResultTemplateRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport("1.1.0");
        GetResultTemplateRequest request = new GetResultTemplateRequest();
        GetResultTemplateReaderV20.readCommonXML(dom, requestElt, request);
        String val = dom.getElementValue(requestElt, "offering");
        request.setOffering(val);
        NodeList obsList = dom.getElements(requestElt, "observedProperty");
        for (int i = 0; i < obsList.getLength(); ++i) {
            val = dom.getElementValue((Element)obsList.item(i));
            request.getObservables().add(val);
        }
        this.checkParameters(request, report);
        return request;
    }

    protected void checkParameters(GetResultTemplateRequest request, OWSExceptionReport report) throws OWSException {
        SWERequestReader.checkParameters(request, report, "SOS");
        if (request.getOffering() == null) {
            report.add(new OWSException("MissingParameterValue", "offering"));
        }
        if (request.getObservables().size() < 1) {
            report.add(new OWSException("MissingParameterValue", "observedProperty"));
        }
        report.process();
    }
}

