/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sos;

import net.opengis.swe.v20.DataComponent;
import net.opengis.swe.v20.DataEncoding;
import org.vast.ogc.OGCRegistry;
import org.vast.ows.OWSException;
import org.vast.ows.sos.GetResultTemplateResponse;
import org.vast.ows.sos.SOSException;
import org.vast.ows.swe.SWEResponseWriter;
import org.vast.swe.SWEUtils;
import org.vast.xml.DOMHelper;
import org.vast.xml.XMLWriterException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GetResultTemplateResponseWriterV20
extends SWEResponseWriter<GetResultTemplateResponse> {
    protected SWEUtils sweUtils = new SWEUtils("2.0");

    @Override
    public Element buildXMLResponse(DOMHelper dom, GetResultTemplateResponse response, String version) throws OWSException {
        try {
            dom.addUserPrefix("sos", OGCRegistry.getNamespaceURI((String)"SOS", (String)version));
            Element rootElt = dom.createElement("sos:" + response.getMessageType());
            this.writeExtensions(dom, rootElt, response);
            DataComponent resultStructure = response.getResultStructure();
            if (resultStructure == null) {
                throw new SOSException("Result structure must be provided");
            }
            Element structPropElt = dom.addElement((Node)rootElt, "sos:resultStructure");
            Element componentElt = this.sweUtils.writeComponent(dom, resultStructure, false);
            structPropElt.appendChild(componentElt);
            DataEncoding resultEncoding = response.getResultEncoding();
            if (resultEncoding == null) {
                throw new SOSException("Result encoding must be provided");
            }
            Element encPropElt = dom.addElement((Node)rootElt, "sos:resultEncoding");
            Element encElt = this.sweUtils.writeEncoding(dom, resultEncoding);
            encPropElt.appendChild(encElt);
            return rootElt;
        }
        catch (XMLWriterException e) {
            throw new SOSException((Exception)((Object)e));
        }
    }
}

