/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sos;

import java.util.Map;
import org.vast.ogc.om.IObservation;
import org.vast.ogc.om.ObservationReaderV20;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.sos.InsertObservationRequest;
import org.vast.ows.sos.SOSException;
import org.vast.ows.swe.SWERequestReader;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InsertObservationReaderV20
extends SWERequestReader<InsertObservationRequest> {
    protected ObservationReaderV20 reader = new ObservationReaderV20();

    @Override
    public InsertObservationRequest readURLParameters(Map<String, String> queryParameters) throws OWSException {
        throw new SOSException("KVP request not supported in SOS 2.0 InsertObservation");
    }

    @Override
    public InsertObservationRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport("1.1.0");
        InsertObservationRequest request = new InsertObservationRequest();
        InsertObservationReaderV20.readCommonXML(dom, requestElt, request);
        String offering = dom.getElementValue(requestElt, "offering");
        request.setOffering(offering);
        try {
            NodeList obsElts = dom.getElements(requestElt, "observation/*");
            for (int i = 0; i < obsElts.getLength(); ++i) {
                Element obsElt = (Element)obsElts.item(i);
                IObservation obs = this.reader.read(dom, obsElt);
                request.getObservations().add(obs);
            }
        }
        catch (Exception e) {
            report.add(new OWSException("InvalidParameterValue", "observation", "Error while parsing observation content", e));
        }
        this.checkParameters(request, report);
        return request;
    }

    protected void checkParameters(InsertObservationRequest request, OWSExceptionReport report) throws OWSException {
        SWERequestReader.checkParameters(request, report, "SOS");
        if (request.getOffering() == null) {
            report.add(new OWSException("MissingParameterValue", "offering"));
        }
        if (request.getObservations() == null || request.getObservations().isEmpty()) {
            report.add(new OWSException("MissingParameterValue", "observation"));
        }
        report.process();
    }
}

