/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sos;

import java.io.IOException;
import org.vast.ogc.OGCRegistry;
import org.vast.ogc.om.IObservation;
import org.vast.ogc.om.ObservationWriterV20;
import org.vast.ows.OWSException;
import org.vast.ows.sos.InsertObservationRequest;
import org.vast.ows.swe.SWERequestWriter;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InsertObservationWriterV20
extends SWERequestWriter<InsertObservationRequest> {
    private ObservationWriterV20 obsWriter = new ObservationWriterV20();

    @Override
    public Element buildXMLQuery(DOMHelper dom, InsertObservationRequest request) throws OWSException {
        dom.addUserPrefix("sos", OGCRegistry.getNamespaceURI((String)"SOS", (String)request.getVersion()));
        Element rootElt = dom.createElement("sos:" + request.getOperation());
        this.addCommonXML(dom, rootElt, request);
        dom.setElementValue(rootElt, "+sos:offering", request.getOffering());
        try {
            for (IObservation obs : request.getObservations()) {
                Element propElt = dom.addElement((Node)rootElt, "+sos:observation");
                Element obsElt = this.obsWriter.write(dom, obs);
                propElt.appendChild(obsElt);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while writing Observation", e);
        }
        return rootElt;
    }
}

