/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sos;

import java.io.IOException;
import java.util.Map;
import net.opengis.swe.v20.DataComponent;
import net.opengis.swe.v20.DataEncoding;
import org.vast.cdm.common.DataSource;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.SweEncodedMessageProcessor;
import org.vast.ows.sos.InsertResultRequest;
import org.vast.ows.swe.SWERequestReader;
import org.vast.swe.DataSourceDOM;
import org.vast.swe.DataSourceURI;
import org.vast.swe.SWEData;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class InsertResultReaderV20
extends SWERequestReader<InsertResultRequest>
implements SweEncodedMessageProcessor {
    protected DataComponent resultStructure;
    protected DataEncoding resultEncoding;

    @Override
    public void setSweCommonStructure(DataComponent structure, DataEncoding encoding) {
        this.resultStructure = structure;
        this.resultEncoding = encoding;
    }

    @Override
    public InsertResultRequest readURLParameters(Map<String, String> queryParameters) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport("1.1.0");
        InsertResultRequest request = new InsertResultRequest();
        this.readCommonQueryArguments(queryParameters, request);
        for (Map.Entry<String, String> item : queryParameters.entrySet()) {
            String argName = item.getKey();
            String argValue = item.getValue();
            if (argName.equalsIgnoreCase("template")) {
                request.setTemplateId(argValue);
                continue;
            }
            if (argValue == null) {
                argValue = "";
            }
            this.addKVPExtension(argName, argValue, request);
        }
        request.setResultDataSource((DataSource)new DataSourceURI("POST"));
        this.checkParameters(request, report);
        return request;
    }

    @Override
    public InsertResultRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport("1.1.0");
        InsertResultRequest request = new InsertResultRequest();
        InsertResultReaderV20.readCommonXML(dom, requestElt, request);
        String templateId = dom.getElementValue(requestElt, "template");
        request.setTemplateId(templateId);
        try {
            Element valuesElt = dom.getElement(requestElt, "resultValues");
            DataSourceDOM domSrc = new DataSourceDOM(dom, valuesElt);
            if (this.resultStructure != null && this.resultEncoding != null) {
                SWEData sweData = new SWEData();
                sweData.setElementType(this.resultStructure);
                sweData.setEncoding(this.resultEncoding);
                sweData.parseData((DataSource)domSrc);
                request.setResultData(sweData);
            } else {
                request.setResultDataSource((DataSource)domSrc);
            }
        }
        catch (IOException e) {
            throw new OWSException("InvalidParameterValue", "resultValues", "Unable to read SWE Common data");
        }
        this.checkParameters(request, report);
        return request;
    }

    protected void checkParameters(InsertResultRequest request, OWSExceptionReport report) throws OWSException {
        SWERequestReader.checkParameters(request, report, "SOS");
        if (request.getTemplateId() == null) {
            report.add(new OWSException("MissingParameterValue", "template"));
        }
        if (request.getResultData() == null && request.getResultDataSource() == null) {
            report.add(new OWSException("MissingParameterValue", "resultValues"));
        }
        report.process();
    }
}

