/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sos;

import java.util.List;
import java.util.Map;
import net.opengis.swe.v20.DataComponent;
import net.opengis.swe.v20.DataEncoding;
import org.vast.ogc.om.IObservation;
import org.vast.ogc.om.ObservationReaderV20;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.sos.InsertResultTemplateRequest;
import org.vast.ows.sos.SOSException;
import org.vast.ows.swe.SWERequestReader;
import org.vast.swe.SWEUtils;
import org.vast.swe.SWEValidator;
import org.vast.xml.DOMHelper;
import org.vast.xml.XMLReaderException;
import org.w3c.dom.Element;

public class InsertResultTemplateReaderV20
extends SWERequestReader<InsertResultTemplateRequest> {
    protected SWEUtils sweUtils = new SWEUtils("2.0");
    protected ObservationReaderV20 obsReader = new ObservationReaderV20();

    @Override
    public InsertResultTemplateRequest readURLParameters(Map<String, String> queryParameters) throws OWSException {
        throw new SOSException("KVP request not supported in SOS 2.0 InsertResultTemplate");
    }

    @Override
    public InsertResultTemplateRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport("1.1.0");
        InsertResultTemplateRequest request = new InsertResultTemplateRequest();
        SWEValidator validator = new SWEValidator();
        InsertResultTemplateReaderV20.readCommonXML(dom, requestElt, request);
        Element templateElt = dom.getElement(requestElt, "proposedTemplate/ResultTemplate");
        String val = dom.getElementValue(templateElt, "offering");
        request.setOffering(val);
        try {
            Element obsElt = dom.getElement(templateElt, "observationTemplate/*");
            if (obsElt != null) {
                IObservation obs = this.obsReader.read(dom, obsElt);
                request.setObservationTemplate(obs);
            }
        }
        catch (XMLReaderException e) {
            throw new OWSException("InvalidParameterValue", "observationTemplate", "Unable to read O&M observation");
        }
        DataComponent structure = null;
        try {
            Element resultStructElt = dom.getElement(templateElt, "resultStructure/*");
            structure = this.sweUtils.readComponent(dom, resultStructElt);
            List errors = validator.validateComponent(structure, null);
            for (Exception e : errors) {
                report.add(new OWSException("InvalidParameterValue", "resultStructure", "Invalid structure definition: " + e.getMessage()));
            }
            request.setResultStructure(structure);
        }
        catch (XMLReaderException e) {
            throw new OWSException("InvalidParameterValue", "resultStructure", "Unable to read SWE Common data");
        }
        try {
            Element resultEncodingElt = dom.getElement(templateElt, "resultEncoding/*");
            DataEncoding encoding = this.sweUtils.readEncoding(dom, resultEncodingElt);
            List errors = validator.validateEncoding(encoding, structure, null);
            for (Exception e : errors) {
                report.add(new OWSException("InvalidParameterValue", "resultEncoding", "Invalid encoding definition: " + e.getMessage()));
            }
            request.setResultEncoding(encoding);
        }
        catch (XMLReaderException e) {
            throw new OWSException("InvalidParameterValue", "resultEncoding", "Unable to read SWE Common encoding");
        }
        this.checkParameters(request, report);
        return request;
    }

    protected void checkParameters(InsertResultTemplateRequest request, OWSExceptionReport report) throws OWSException {
        SWERequestReader.checkParameters(request, report, "SOS");
        if (request.getOffering() == null) {
            report.add(new OWSException("MissingParameterValue", "offering"));
        }
        if (request.getResultStructure() == null) {
            report.add(new OWSException("MissingParameterValue", "resultStructure"));
        }
        if (request.getResultEncoding() == null) {
            report.add(new OWSException("MissingParameterValue", "resultEncoding"));
        }
        report.process();
    }
}

