/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sos;

import org.vast.ogc.OGCRegistry;
import org.vast.ogc.om.ObservationWriterV20;
import org.vast.ows.OWSException;
import org.vast.ows.sos.InsertResultTemplateRequest;
import org.vast.ows.swe.SWERequestWriter;
import org.vast.swe.SWEUtils;
import org.vast.xml.DOMHelper;
import org.vast.xml.XMLWriterException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InsertResultTemplateWriterV20
extends SWERequestWriter<InsertResultTemplateRequest> {
    protected SWEUtils sweUtils = new SWEUtils("2.0");
    protected ObservationWriterV20 obsWriter = new ObservationWriterV20();

    @Override
    public Element buildXMLQuery(DOMHelper dom, InsertResultTemplateRequest request) throws OWSException {
        dom.addUserPrefix("sos", OGCRegistry.getNamespaceURI((String)"SOS", (String)request.getVersion()));
        dom.addUserPrefix("swe", OGCRegistry.getNamespaceURI((String)"SWE", (String)"2.0"));
        Element rootElt = dom.createElement("sos:" + request.getOperation());
        this.addCommonXML(dom, rootElt, request);
        Element templateElt = dom.addElement((Node)rootElt, "sos:proposedTemplate/sos:ResultTemplate");
        dom.setElementValue(templateElt, "+sos:offering", request.getOffering());
        try {
            Element obsPropertyElt = dom.addElement((Node)templateElt, "sos:observationTemplate");
            Element obsElt = this.obsWriter.write(dom, request.getObservationTemplate());
            obsPropertyElt.appendChild(obsElt);
        }
        catch (XMLWriterException e) {
            throw new OWSException("Error while writing observation", (Exception)((Object)e));
        }
        try {
            Element structurePropertyElt = dom.addElement((Node)templateElt, "sos:resultStructure");
            Element structureElt = this.sweUtils.writeComponent(dom, request.getResultStructure(), false);
            structurePropertyElt.appendChild(structureElt);
        }
        catch (XMLWriterException e) {
            throw new OWSException("Error while writing SWE Common result structure", (Exception)((Object)e));
        }
        try {
            Element encodingPropertyElt = dom.addElement((Node)templateElt, "sos:resultEncoding");
            Element encodingElt = this.sweUtils.writeEncoding(dom, request.getResultEncoding());
            encodingPropertyElt.appendChild(encodingElt);
        }
        catch (XMLWriterException e) {
            throw new OWSException("Error while writing SWE Common result encoding", (Exception)((Object)e));
        }
        return rootElt;
    }
}

