/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sos;

import java.util.Map;
import net.opengis.sensorml.v20.AbstractProcess;
import org.vast.ogc.OGCRegistry;
import org.vast.ogc.gml.FeatureRef;
import org.vast.ogc.xlink.IXlinkReference;
import org.vast.ogc.xlink.XlinkUtils;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.sos.InsertSensorRequest;
import org.vast.ows.sos.SOSException;
import org.vast.ows.swe.SWERequestReader;
import org.vast.sensorML.SMLUtils;
import org.vast.xml.DOMHelper;
import org.vast.xml.XMLReaderException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InsertSensorReaderV20
extends SWERequestReader<InsertSensorRequest> {
    SMLUtils smlUtils = new SMLUtils("2.0");

    @Override
    public InsertSensorRequest readURLParameters(Map<String, String> queryParameters) throws OWSException {
        throw new SOSException("KVP request not supported in SOS 2.0 InsertSensor");
    }

    @Override
    public InsertSensorRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport("1.1.0");
        InsertSensorRequest request = new InsertSensorRequest();
        InsertSensorReaderV20.readCommonXML(dom, requestElt, request);
        String val = dom.getElementValue(requestElt, "procedureDescriptionFormat");
        request.setProcedureDescriptionFormat(val);
        if (request.getProcedureDescriptionFormat() == null) {
            report.add(new OWSException("MissingParameterValue", "procedureDescriptionFormat"));
            report.process();
        }
        if (!val.equals(OGCRegistry.getNamespaceURI((String)SMLUtils.SENSORML, (String)"2.0"))) {
            throw new OWSException("InvalidParameterValue", "procedureDescription", "Unsupported format: " + val);
        }
        try {
            Element procedureElt = dom.getElement(requestElt, "procedureDescription/*");
            AbstractProcess process = this.smlUtils.readProcess(dom, procedureElt);
            request.setProcedureDescription(process);
        }
        catch (XMLReaderException e) {
            throw new OWSException("InvalidParameterValue", "procedure", "Unable to read SensorML description:\n" + e.getMessage());
        }
        NodeList obsPropElts = dom.getElements(requestElt, "observableProperty");
        for (int i = 0; i < obsPropElts.getLength(); ++i) {
            String obsProp = dom.getElementValue((Element)obsPropElts.item(i));
            request.getObservableProperties().add(obsProp);
        }
        NodeList featureElts = dom.getElements(requestElt, "relatedFeature/FeatureRelationship");
        for (int i = 0; i < featureElts.getLength(); ++i) {
            Element featElt = (Element)featureElts.item(i);
            FeatureRef featureRef = new FeatureRef();
            Element targetElt = dom.getElement(featElt, "target");
            XlinkUtils.readXlinkAttributes((DOMHelper)dom, (Element)targetElt, (IXlinkReference)featureRef);
            String role = dom.getElementValue(featElt, "role");
            if (role != null) {
                featureRef.setArcRole(role);
            }
            request.getRelatedFeatures().add(featureRef);
        }
        Element metadataElt = dom.getElement(requestElt, "metadata/SosInsertionMetadata");
        if (metadataElt != null) {
            NodeList obsTypeElts = dom.getElements(metadataElt, "observationType");
            for (int i = 0; i < obsTypeElts.getLength(); ++i) {
                val = dom.getElementValue((Element)obsTypeElts.item(i));
                request.getObservationTypes().add(val);
            }
            NodeList foiTypeElts = dom.getElements(metadataElt, "featureOfInterestType");
            for (int i = 0; i < foiTypeElts.getLength(); ++i) {
                val = dom.getElementValue((Element)foiTypeElts.item(i));
                request.getFoiTypes().add(val);
            }
        }
        this.checkParameters(request, report);
        return request;
    }

    protected void checkParameters(InsertSensorRequest request, OWSExceptionReport report) throws OWSException {
        SWERequestReader.checkParameters(request, report, "SOS");
        if (request.getObservationTypes().isEmpty()) {
            report.add(new OWSException("MissingParameterValue", "observationType"));
        }
        if (request.getFoiTypes().isEmpty()) {
            report.add(new OWSException("MissingParameterValue", "featureOfInterestType"));
        }
        if (request.getProcedureDescription() == null) {
            report.add(new OWSException("MissingParameterValue", "procedureDescription"));
        }
        report.process();
    }
}

