/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sos;

import java.io.IOException;
import org.vast.ogc.OGCRegistry;
import org.vast.ogc.gml.FeatureRef;
import org.vast.ows.OWSException;
import org.vast.ows.sos.InsertSensorRequest;
import org.vast.ows.swe.SWERequestWriter;
import org.vast.sensorML.SMLUtils;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InsertSensorWriterV20
extends SWERequestWriter<InsertSensorRequest> {
    SMLUtils smlUtils = new SMLUtils("2.0");

    @Override
    public Element buildXMLQuery(DOMHelper dom, InsertSensorRequest request) throws OWSException {
        dom.addUserPrefix("sos", OGCRegistry.getNamespaceURI((String)"SOS", (String)request.getVersion()));
        dom.addUserPrefix("swes", OGCRegistry.getNamespaceURI((String)"SWES", (String)"2.0"));
        Element rootElt = dom.createElement("swes:" + request.getOperation());
        this.addCommonXML(dom, rootElt, request);
        dom.setElementValue(rootElt, "swes:procedureDescriptionFormat", request.getProcedureDescriptionFormat());
        try {
            String format = request.getProcedureDescriptionFormat();
            if (!format.equals(OGCRegistry.getNamespaceURI((String)SMLUtils.SENSORML, (String)"2.0"))) {
                throw new OWSException("Unsupported format: " + request.getProcedureDescriptionFormat());
            }
            Element procedureElt = dom.addElement((Node)rootElt, "swes:procedureDescription");
            Element processElt = this.smlUtils.writeProcess(dom, request.getProcedureDescription());
            procedureElt.appendChild(processElt);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while writing SensorML document", e);
        }
        for (String observable : request.getObservableProperties()) {
            dom.setElementValue(rootElt, "+swes:observableProperty", observable);
        }
        for (FeatureRef featureRef : request.getRelatedFeatures()) {
            dom.setElementValue(rootElt, "+swes:relatedFeature/swes:FeatureRelationship", featureRef.getHref());
        }
        Element insertMetaElt = dom.addElement((Node)rootElt, "swes:metadata/sos:SosInsertionMetadata");
        for (String obsType : request.getObservationTypes()) {
            dom.setElementValue(insertMetaElt, "+sos:observationType", obsType);
        }
        for (String foiType : request.getFoiTypes()) {
            dom.setElementValue(insertMetaElt, "+sos:featureOfInterestType", foiType);
        }
        return rootElt;
    }
}

