/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sos;

import java.util.Collection;
import net.opengis.fes.v20.FilterCapabilities;
import org.vast.ogc.gml.GMLUtils;
import org.vast.ows.OWSException;
import org.vast.ows.OWSServiceCapabilities;
import org.vast.ows.fes.FESUtils;
import org.vast.ows.sos.SOSException;
import org.vast.ows.sos.SOSInsertionCapabilities;
import org.vast.ows.sos.SOSOfferingCapabilities;
import org.vast.ows.sos.SOSServiceCapabilities;
import org.vast.ows.swe.SWESCapabilitiesReaderV20;
import org.vast.xml.DOMHelper;
import org.vast.xml.XMLReaderException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SOSCapabilitiesReaderV20
extends SWESCapabilitiesReaderV20 {
    GMLUtils gmlUtils = new GMLUtils("3.2");
    FESUtils fesUtils = new FESUtils("2.0");

    @Override
    public SOSServiceCapabilities readXMLResponse(DOMHelper dom, Element capabilitiesElt) throws OWSException {
        try {
            Element filterCapsElt;
            SOSServiceCapabilities caps = new SOSServiceCapabilities();
            this.readOWSCapabilities(dom, capabilitiesElt, caps);
            Element insertionCapsElt = dom.getElement(capabilitiesElt, "extension/InsertionCapabilities");
            if (insertionCapsElt != null) {
                SOSInsertionCapabilities insertionCaps = new SOSInsertionCapabilities();
                this.readProcedureFormats(dom, insertionCapsElt, insertionCaps.getProcedureFormats());
                this.readObservationTypes(dom, insertionCapsElt, insertionCaps.getObservationTypes());
                this.readFoiTypes(dom, insertionCapsElt, insertionCaps.getFoiTypes());
                this.readSupportedEncodings(dom, insertionCapsElt, insertionCaps.getSupportedEncodings());
                caps.setInsertionCapabilities(insertionCaps);
            }
            if ((filterCapsElt = dom.getElement(capabilitiesElt, "filterCapabilities/Filter_Capabilities")) != null) {
                FilterCapabilities filterCaps = this.fesUtils.readFilterCapabilities(filterCapsElt);
                caps.setFilterCapabilities(filterCaps);
            }
            return caps;
        }
        catch (Exception e) {
            throw new OWSException("Error while parsing capabilities document XML", e);
        }
    }

    @Override
    protected void readContents(DOMHelper dom, Element capsElt, OWSServiceCapabilities serviceCaps) throws OWSException {
        try {
            Element contentsElt = dom.getElement(capsElt, "contents/Contents");
            Collection<String> serviceProcFormats = this.readProcedureFormats(dom, contentsElt, null);
            Collection<String> serviceObsProperties = this.readObservableProperties(dom, contentsElt, null);
            Collection<String> serviceRelFeatures = this.readRelatedFeatures(dom, contentsElt, null);
            Collection<String> serviceRespFormats = this.readResponseFormats(dom, contentsElt, null);
            Collection<String> serviceObsTypes = this.readObservationTypes(dom, contentsElt, null);
            Collection<String> serviceFoiTypes = this.readFoiTypes(dom, contentsElt, null);
            NodeList offerings = dom.getElements(contentsElt, "offering/ObservationOffering");
            int numOfferings = offerings.getLength();
            for (int i = 0; i < numOfferings; ++i) {
                Element resultTimeElt;
                Element phenTimeElt;
                Element offeringElt = (Element)offerings.item(i);
                SOSOfferingCapabilities offering = new SOSOfferingCapabilities();
                offering.setParent(serviceCaps);
                super.readCommonOfferingProperties(dom, offeringElt, offering, serviceProcFormats, serviceObsProperties, serviceRelFeatures);
                Element envElt = dom.getElement(offeringElt, "observedArea/Envelope");
                if (envElt != null) {
                    offering.getObservedAreas().add(this.gmlUtils.readEnvelopeAsBbox(dom, envElt));
                }
                if ((phenTimeElt = dom.getElement(offeringElt, "phenomenonTime/TimePeriod")) != null) {
                    offering.setPhenomenonTime(this.gmlUtils.readTimePrimitiveAsTimeExtent(dom, phenTimeElt));
                }
                if ((resultTimeElt = dom.getElement(offeringElt, "resultTime/TimePeriod")) != null) {
                    offering.setResultTime(this.gmlUtils.readTimePrimitiveAsTimeExtent(dom, resultTimeElt));
                }
                this.readResponseFormats(dom, offeringElt, offering.getResponseFormats());
                if (offering.getResponseFormats().isEmpty()) {
                    offering.getResponseFormats().addAll(serviceRespFormats);
                }
                this.readObservationTypes(dom, offeringElt, offering.getObservationTypes());
                if (offering.getObservationTypes().isEmpty()) {
                    offering.getObservationTypes().addAll(serviceObsTypes);
                }
                this.readFoiTypes(dom, offeringElt, offering.getFoiTypes());
                if (offering.getFoiTypes().isEmpty()) {
                    offering.getFoiTypes().addAll(serviceFoiTypes);
                }
                ((SOSServiceCapabilities)serviceCaps).getLayers().add(offering);
            }
        }
        catch (XMLReaderException e) {
            throw new SOSException(e.getMessage());
        }
    }

    protected Collection<String> readResponseFormats(DOMHelper dom, Element parentElt, Collection<String> respFormats) {
        return this.readStringList(dom, parentElt, "responseFormat", respFormats);
    }

    protected Collection<String> readObservationTypes(DOMHelper dom, Element parentElt, Collection<String> obsTypes) {
        return this.readStringList(dom, parentElt, "observationType", obsTypes);
    }

    protected Collection<String> readFoiTypes(DOMHelper dom, Element parentElt, Collection<String> foiTypes) {
        return this.readStringList(dom, parentElt, "featureOfInterestType", foiTypes);
    }

    protected Collection<String> readSupportedEncodings(DOMHelper dom, Element parentElt, Collection<String> encodings) {
        return this.readStringList(dom, parentElt, "supportedEncoding", encodings);
    }
}

