/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sos;

import net.opengis.fes.v20.FilterCapabilities;
import org.vast.ogc.OGCRegistry;
import org.vast.ogc.gml.GMLUtils;
import org.vast.ows.OWSException;
import org.vast.ows.OWSServiceCapabilities;
import org.vast.ows.fes.FESUtils;
import org.vast.ows.sos.SOSInsertionCapabilities;
import org.vast.ows.sos.SOSOfferingCapabilities;
import org.vast.ows.sos.SOSServiceCapabilities;
import org.vast.ows.swe.SWESCapabilitiesWriterV20;
import org.vast.util.Bbox;
import org.vast.util.TimeExtent;
import org.vast.xml.DOMHelper;
import org.vast.xml.XMLWriterException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOSCapabilitiesWriterV20
extends SWESCapabilitiesWriterV20 {
    GMLUtils gmlUtils = new GMLUtils("3.2");
    FESUtils fesUtils = new FESUtils("2.0");

    @Override
    public Element buildXMLResponse(DOMHelper dom, OWSServiceCapabilities caps, String version) throws OWSException {
        dom.addUserPrefix("sos", OGCRegistry.getNamespaceURI((String)"SOS", (String)version));
        dom.addUserPrefix("swes", OGCRegistry.getNamespaceURI((String)"SWES", (String)"2.0"));
        dom.addUserPrefix("ows", OGCRegistry.getNamespaceURI((String)"OWS", (String)"1.1"));
        dom.addUserPrefix("xlink", OGCRegistry.getNamespaceURI((String)"XLINK"));
        Element capsElt = dom.createElement("sos:Capabilities");
        this.writeRootAttributes(dom, capsElt, caps, version);
        this.writeServiceIdentification(dom, capsElt, caps);
        this.writeServiceProvider(dom, capsElt, caps.getServiceProvider());
        this.writeOperationsMetadata(dom, capsElt, caps);
        this.writeInsertionCapabilities(dom, capsElt, (SOSServiceCapabilities)caps);
        this.writeFilterCapabilities(dom, capsElt, (SOSServiceCapabilities)caps);
        this.writeContents(dom, capsElt, caps, version);
        return capsElt;
    }

    protected void writeInsertionCapabilities(DOMHelper dom, Element capsElt, SOSServiceCapabilities serviceCaps) throws OWSException {
        SOSInsertionCapabilities insertionCaps = serviceCaps.getInsertionCapabilities();
        if (insertionCaps != null) {
            Element insertionCapsElt = dom.addElement((Node)capsElt, "sos:extension/sos:InsertionCapabilities");
            for (String token : insertionCaps.getProcedureFormats()) {
                dom.setElementValue(insertionCapsElt, "+sos:procedureDescriptionFormat", token);
            }
            for (String token : insertionCaps.getFoiTypes()) {
                dom.setElementValue(insertionCapsElt, "+sos:featureOfInterestType", token);
            }
            for (String token : insertionCaps.getObservationTypes()) {
                dom.setElementValue(insertionCapsElt, "+sos:observationType", token);
            }
            for (String token : insertionCaps.getSupportedEncodings()) {
                dom.setElementValue(insertionCapsElt, "+sos:supportedEncoding", token);
            }
        }
    }

    protected void writeFilterCapabilities(DOMHelper dom, Element capsElt, SOSServiceCapabilities serviceCaps) throws OWSException {
        try {
            FilterCapabilities filterCaps = serviceCaps.getFilterCapabilities();
            if (filterCaps != null) {
                Element filterCapsElt = this.fesUtils.writeFilterCapabilities(dom, filterCaps);
                Element capsPropElt = dom.addElement((Node)capsElt, "sos:filterCapabilities");
                capsPropElt.appendChild(filterCapsElt);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Internal error while writing filter capabilities", e);
        }
    }

    @Override
    protected void writeContents(DOMHelper dom, Element capsElt, OWSServiceCapabilities serviceCaps, String version) throws OWSException {
        Element contentsElt = dom.addElement((Node)capsElt, "sos:contents/sos:Contents");
        super.writeCommonContentsProperties(dom, contentsElt, serviceCaps);
        for (SOSOfferingCapabilities offeringCaps : ((SOSServiceCapabilities)serviceCaps).getLayers()) {
            try {
                TimeExtent timePeriod;
                Element envElt;
                Element offeringElt = dom.addElement((Node)contentsElt, "+swes:offering/sos:ObservationOffering");
                super.writeCommonOfferingProperties(dom, offeringElt, serviceCaps, offeringCaps);
                if (offeringCaps.getObservedAreas() != null && !offeringCaps.getObservedAreas().isEmpty()) {
                    Bbox bbox = offeringCaps.getObservedAreas().get(0);
                    envElt = this.gmlUtils.writeBboxAsEnvelope(dom, bbox);
                    dom.addElement((Node)offeringElt, "sos:observedArea").appendChild(envElt);
                }
                if ((timePeriod = offeringCaps.getPhenomenonTime()) != null) {
                    envElt = this.gmlUtils.writeTimeExtentAsTimePeriod(dom, timePeriod);
                    dom.addElement((Node)offeringElt, "sos:phenomenonTime").appendChild(envElt);
                }
                if ((timePeriod = offeringCaps.getResultTime()) != null) {
                    envElt = this.gmlUtils.writeTimeExtentAsTimePeriod(dom, timePeriod);
                    dom.addElement((Node)offeringElt, "sos:resultTime").appendChild(envElt);
                }
                if (!offeringCaps.getResponseFormats().equals(this.getCommonListEntries(serviceCaps, "getResponseFormats"))) {
                    for (String token : offeringCaps.getResponseFormats()) {
                        dom.setElementValue(offeringElt, "+sos:responseFormat", token);
                    }
                }
                if (!offeringCaps.getObservationTypes().equals(this.getCommonListEntries(serviceCaps, "getObservationTypes"))) {
                    for (String token : offeringCaps.getObservationTypes()) {
                        dom.setElementValue(offeringElt, "+sos:observationType", token);
                    }
                }
                if (offeringCaps.getFoiTypes().equals(this.getCommonListEntries(serviceCaps, "getFoiTypes"))) continue;
                for (String token : offeringCaps.getFoiTypes()) {
                    dom.setElementValue(offeringElt, "+sos:featureOfInterestType", token);
                }
            }
            catch (XMLWriterException e) {
                throw new RuntimeException("Error writing offering " + offeringCaps.getIdentifier(), e);
            }
        }
        for (String token : this.getCommonListEntries(serviceCaps, "getResponseFormats")) {
            dom.setElementValue(contentsElt, "+sos:responseFormat", token);
        }
        for (String token : this.getCommonListEntries(serviceCaps, "getObservationTypes")) {
            dom.setElementValue(contentsElt, "+sos:observationType", token);
        }
        for (String token : this.getCommonListEntries(serviceCaps, "getFoiTypes")) {
            dom.setElementValue(contentsElt, "+sos:featureOfInterestType", token);
        }
    }
}

