/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sos;

import net.opengis.swe.v20.DataComponent;
import net.opengis.swe.v20.DataEncoding;
import org.vast.ogc.OGCRegistry;
import org.vast.ows.AbstractRequestReader;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.OWSRequest;
import org.vast.ows.OWSRequestReader;
import org.vast.ows.OWSUtils;
import org.vast.ows.SweEncodedMessageProcessor;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class SOSUtils
extends OWSUtils {
    public OWSRequest readSweEncodedRequest(DOMHelper dom, Element requestElt, DataComponent structure, DataEncoding encoding) throws OWSException {
        OWSRequest request = new OWSRequest();
        AbstractRequestReader.readCommonXML(dom, requestElt, request);
        OWSExceptionReport report = new OWSExceptionReport();
        AbstractRequestReader.checkParameters(request, report, "SOS");
        report.process();
        try {
            OWSRequestReader reader = (OWSRequestReader)OGCRegistry.createReader((String)"SOS", (String)request.getOperation(), (String)request.getVersion());
            ((SweEncodedMessageProcessor)((Object)reader)).setSweCommonStructure(structure, encoding);
            return reader.readXMLQuery(dom, requestElt);
        }
        catch (IllegalStateException e) {
            String spec = "SOS " + request.getOperation() + " v" + request.getVersion();
            throw new OWSException("No support for " + spec, e);
        }
    }
}

