/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import java.util.Map;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.sps.CancelRequest;
import org.vast.ows.sps.SPSException;
import org.vast.ows.swe.SWERequestReader;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class CancelRequestReaderV20
extends SWERequestReader<CancelRequest> {
    @Override
    public CancelRequest readURLParameters(Map<String, String> queryParameters) throws OWSException {
        throw new SPSException("KVP request not supported in SPS 2.0 Cancel");
    }

    @Override
    public CancelRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        CancelRequest request = new CancelRequest();
        CancelRequestReaderV20.readCommonXML(dom, requestElt, request);
        String taskID = dom.getElementValue(requestElt, "task");
        request.setTaskID(taskID);
        this.checkParameters(request, new OWSExceptionReport());
        return request;
    }

    protected void checkParameters(CancelRequest request, OWSExceptionReport report) throws OWSException {
        CancelRequestReaderV20.checkParameters(request, report, "SPS");
        if (request.getTaskID() == null) {
            report.add(new OWSException("MissingParameterValue", "task"));
        }
        report.process();
    }
}

