/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import java.util.Map;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.sps.ConfirmRequest;
import org.vast.ows.sps.SPSException;
import org.vast.ows.swe.SWERequestReader;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class ConfirmRequestReaderV20
extends SWERequestReader<ConfirmRequest> {
    @Override
    public ConfirmRequest readURLParameters(Map<String, String> queryParameters) throws OWSException {
        throw new SPSException("KVP request not supported in SPS 2.0 Confirm");
    }

    @Override
    public ConfirmRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        ConfirmRequest request = new ConfirmRequest();
        ConfirmRequestReaderV20.readCommonXML(dom, requestElt, request);
        String taskID = dom.getElementValue(requestElt, "task");
        request.setTaskID(taskID);
        this.checkParameters(request, new OWSExceptionReport());
        return request;
    }

    protected void checkParameters(ConfirmRequest request, OWSExceptionReport report) throws OWSException {
        ConfirmRequestReaderV20.checkParameters(request, report, "SPS");
        if (request.getTaskID() == null) {
            report.add(new OWSException("MissingParameterValue", "task"));
        }
        report.process();
    }
}

