/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import org.vast.ogc.OGCRegistry;
import org.vast.ows.OWSReference;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class DescribeResultAccessReference
extends OWSReference {
    public static final String ROLE_RESOURCE = "http://www.opengis.net/spec/SPS/2.0/referenceType/Resource";
    public static final String ROLE_FOLDER = "http://www.opengis.net/spec/SPS/2.0/referenceType/Folder";
    public static final String ROLE_SERVICE_KVP = "http://www.opengis.net/spec/SPS/2.0/referenceType/FullURLAccess";
    public static final String ROLE_SERVICE_POST = "http://www.opengis.net/spec/SPS/2.0/referenceType/FullServiceAccess";
    public static final String ROLE_SERVICE_ENDPOINT = "http://www.opengis.net/spec/SPS/2.0/referenceType/ServiceURL";

    public void setDataAccessType(String dataAccessType) {
        Element spsMetaElt = this.findSPSMetadata();
        if (spsMetaElt == null) {
            this.getMetadata().remove(spsMetaElt);
        }
        DOMHelper dom = new DOMHelper();
        dom.addUserPrefix("sps", OGCRegistry.getNamespaceURI((String)"SPS", (String)"2.0"));
        spsMetaElt = dom.createElement("sps:SPSMetadata");
        dom.setElementValue(spsMetaElt, "sps:dataAccessType", dataAccessType);
        this.getMetadata().add(spsMetaElt);
    }

    public String getDataAccessType() {
        Element spsMetaElt = this.findSPSMetadata();
        if (spsMetaElt == null) {
            return null;
        }
        DOMHelper dom = new DOMHelper();
        return dom.getElementValue(spsMetaElt, "dataAccessType");
    }

    protected Element findSPSMetadata() {
        for (Object obj : this.getMetadata()) {
            if (!(obj instanceof Element) || !((Element)obj).getLocalName().equals("SPSMetadata")) continue;
            return (Element)obj;
        }
        return null;
    }
}

