/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import java.util.Map;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.sps.DescribeResultAccessRequest;
import org.vast.ows.swe.SWERequestReader;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class DescribeResultAccessRequestReaderV20
extends SWERequestReader<DescribeResultAccessRequest> {
    @Override
    public DescribeResultAccessRequest readURLParameters(Map<String, String> queryParameters) throws OWSException {
        DescribeResultAccessRequest request = new DescribeResultAccessRequest();
        for (Map.Entry<String, String> item : queryParameters.entrySet()) {
            String argName = item.getKey();
            String argValue = item.getValue();
            if (argName.equalsIgnoreCase("service")) {
                request.setService(argValue);
                continue;
            }
            if (argName.equalsIgnoreCase("version")) {
                request.setVersion(argValue);
                continue;
            }
            if (argName.equalsIgnoreCase("request")) {
                request.setOperation(argValue);
                continue;
            }
            if (argName.equalsIgnoreCase("procedure")) {
                request.setProcedureID(argValue);
                continue;
            }
            if (argName.equalsIgnoreCase("task")) {
                request.setTaskID(argValue);
                continue;
            }
            throw new OWSException("Invalid KVP Request: Unknown Argument " + argName);
        }
        this.checkParameters(request, new OWSExceptionReport());
        return request;
    }

    @Override
    public DescribeResultAccessRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        DescribeResultAccessRequest request = new DescribeResultAccessRequest();
        DescribeResultAccessRequestReaderV20.readCommonXML(dom, requestElt, request);
        String taskID = dom.getElementValue(requestElt, "target/task");
        request.setTaskID(taskID);
        String procedureID = dom.getElementValue(requestElt, "target/procedure");
        request.setProcedureID(procedureID);
        this.checkParameters(request, new OWSExceptionReport());
        return request;
    }

    protected void checkParameters(DescribeResultAccessRequest request, OWSExceptionReport report) throws OWSException {
        DescribeResultAccessRequestReaderV20.checkParameters(request, report, "SPS");
        if (request.getProcedureID() == null && request.getTaskID() == null) {
            report.add(new OWSException("MissingParameterValue", "task OR procedure"));
        }
        report.process();
    }
}

