/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import org.vast.ows.OWSCommonReaderV11;
import org.vast.ows.OWSException;
import org.vast.ows.OWSReferenceGroup;
import org.vast.ows.sps.DescribeResultAccessResponse;
import org.vast.ows.swe.SWEResponseReader;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DescribeResultAccessResponseReaderV20
extends SWEResponseReader<DescribeResultAccessResponse> {
    protected OWSCommonReaderV11 owsReader = new OWSCommonReaderV11();

    @Override
    public DescribeResultAccessResponse readXMLResponse(DOMHelper dom, Element responseElt) throws OWSException {
        DescribeResultAccessResponse response = new DescribeResultAccessResponse();
        response.setVersion("2.0");
        Element noDataElt = dom.getElement(responseElt, "availability/unavailable/DataNotAvailable");
        if (noDataElt != null) {
            String reasonCode = dom.getElementValue(noDataElt, "unavailableCode");
            response.setReasonCode(reasonCode);
            String description = dom.getElementValue(noDataElt, "message");
            response.setDescription(description);
        } else {
            Element dataElt = dom.addElement((Node)responseElt, "availability/available/DataAvailable");
            NodeList refGroupElts = dom.getElements(dataElt, "dataReference/ReferenceGroup");
            for (int i = 0; i < refGroupElts.getLength(); ++i) {
                OWSReferenceGroup refGroup = new OWSReferenceGroup();
                Element refGroupElt = (Element)refGroupElts.item(i);
                this.owsReader.readReferenceGroup(dom, refGroupElt, refGroup);
                response.getResultGroups().add(refGroup);
            }
        }
        this.readXMLExtensions(dom, responseElt, response);
        return response;
    }
}

