/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import org.vast.ogc.OGCRegistry;
import org.vast.ows.OWSCommonWriterV11;
import org.vast.ows.OWSException;
import org.vast.ows.OWSReferenceGroup;
import org.vast.ows.sps.DescribeResultAccessResponse;
import org.vast.ows.swe.SWEResponseWriter;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DescribeResultAccessResponseWriterV20
extends SWEResponseWriter<DescribeResultAccessResponse> {
    protected OWSCommonWriterV11 owsWriter = new OWSCommonWriterV11();

    @Override
    public Element buildXMLResponse(DOMHelper dom, DescribeResultAccessResponse response, String version) throws OWSException {
        dom.addUserPrefix("sps", OGCRegistry.getNamespaceURI((String)"SPS", (String)version));
        dom.addUserPrefix("ows", OGCRegistry.getNamespaceURI((String)"OWS", (String)"1.1"));
        Element rootElt = dom.createElement("sps:" + response.getMessageType());
        this.writeExtensions(dom, rootElt, response);
        if (response.getReasonCode() != null) {
            Element noDataElt = dom.addElement((Node)rootElt, "sps:availability/sps:unavailable/sps:DataNotAvailable");
            dom.setElementValue(noDataElt, "sps:unavailableCode", response.getReasonCode());
            if (response.getDescription() != null) {
                dom.setElementValue(noDataElt, "sps:message", response.getDescription());
            }
        } else {
            Element dataElt = dom.addElement((Node)rootElt, "sps:availability/sps:available/sps:DataAvailable");
            for (OWSReferenceGroup refGroup : response.getResultGroups()) {
                Element refGroupElt = dom.addElement((Node)dataElt, "+sps:dataReference/ows:ReferenceGroup");
                this.owsWriter.buildRefGroup(dom, refGroupElt, refGroup);
            }
        }
        return rootElt;
    }
}

