/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import java.util.Map;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.sps.DescribeTaskingRequest;
import org.vast.ows.swe.SWERequestReader;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class DescribeTaskingRequestReaderV20
extends SWERequestReader<DescribeTaskingRequest> {
    @Override
    public DescribeTaskingRequest readURLParameters(Map<String, String> queryParameters) throws OWSException {
        DescribeTaskingRequest request = new DescribeTaskingRequest();
        for (Map.Entry<String, String> item : queryParameters.entrySet()) {
            String argName = item.getKey();
            String argValue = item.getValue();
            if (argName.equalsIgnoreCase("service")) {
                request.setService(argValue);
                continue;
            }
            if (argName.equalsIgnoreCase("version")) {
                request.setVersion(argValue);
                continue;
            }
            if (argName.equalsIgnoreCase("request")) {
                request.setOperation(argValue);
                continue;
            }
            if (argName.equalsIgnoreCase("procedure")) {
                request.setProcedureID(argValue);
                continue;
            }
            throw new OWSException("Invalid KVP Request: Unknown Argument " + argName);
        }
        this.checkParameters(request, new OWSExceptionReport());
        return request;
    }

    @Override
    public DescribeTaskingRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        DescribeTaskingRequest request = new DescribeTaskingRequest();
        DescribeTaskingRequestReaderV20.readCommonXML(dom, requestElt, request);
        String procedureID = dom.getElementValue(requestElt, "procedure");
        request.setProcedureID(procedureID);
        this.checkParameters(request, new OWSExceptionReport());
        return request;
    }

    protected void checkParameters(DescribeTaskingRequest request, OWSExceptionReport report) throws OWSException {
        DescribeTaskingRequestReaderV20.checkParameters(request, report, "SPS");
        if (request.getProcedureID() == null) {
            report.add(new OWSException("MissingParameterValue", "procedure"));
        }
        report.process();
    }
}

