/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import java.util.ArrayList;
import net.opengis.swe.v20.DataComponent;
import org.vast.data.DataIterator;
import org.vast.ows.OWSResponse;

public class DescribeTaskingResponse
extends OWSResponse {
    protected DataComponent taskingParameters;
    protected DataComponent updatableParameters;

    public DescribeTaskingResponse() {
        this.service = "SPS";
        this.messageType = "DescribeTaskingResponse";
    }

    public DataComponent getTaskingParameters() {
        return this.taskingParameters;
    }

    public void setTaskingParameters(DataComponent taskingParameters) {
        this.taskingParameters = taskingParameters;
    }

    public DataComponent getUpdatableParameters() {
        if (this.updatableParameters != null) {
            return this.updatableParameters;
        }
        this.updatableParameters = this.taskingParameters.copy();
        this.updatableParameters.clearData();
        DataIterator it = new DataIterator(this.updatableParameters);
        ArrayList<DataComponent> componentsToDelete = new ArrayList<DataComponent>();
        while (it.hasNext()) {
            DataComponent nextComp = it.next();
            if (!nextComp.isSetUpdatable() || nextComp.getUpdatable()) continue;
            componentsToDelete.add(nextComp);
            if (nextComp.getComponentCount() <= 0) continue;
            it.skipChildren();
        }
        for (DataComponent component : componentsToDelete) {
            DataComponent parent = component.getParent();
            if (parent == null) {
                return null;
            }
            if (parent.getComponentCount() <= 1) {
                throw new IllegalStateException("Component " + component.getName() + " should be updatable since its parent is updatable");
            }
            int compIndex = parent.getComponentIndex(component.getName());
            parent.removeComponent(compIndex);
        }
        return this.updatableParameters;
    }

    public void setUpdatableParameters(DataComponent updatableParameters) {
        this.updatableParameters = updatableParameters;
    }
}

