/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import org.vast.ows.OWSException;
import org.vast.ows.sps.FeasibilityReport;
import org.vast.ows.sps.GetFeasibilityResponse;
import org.vast.ows.sps.SPSCommonReaderV20;
import org.vast.ows.sps.SPSException;
import org.vast.ows.swe.SWEResponseReader;
import org.vast.util.DateTime;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class GetFeasibilityResponseReaderV20
extends SWEResponseReader<GetFeasibilityResponse> {
    protected SPSCommonReaderV20 commonReader = new SPSCommonReaderV20();

    @Override
    public GetFeasibilityResponse readXMLResponse(DOMHelper dom, Element responseElt) throws OWSException {
        try {
            Element reportElt;
            GetFeasibilityResponse response = new GetFeasibilityResponse();
            response.setVersion("2.0");
            String isoDate = dom.getElementValue(responseElt, "latestResponseTime");
            if (isoDate != null) {
                DateTime latestResponseTime = new DateTime(this.timeFormat.parseIso(isoDate));
                response.setLatestResponseTime(latestResponseTime);
            }
            if ((reportElt = dom.getElement(responseElt, "result/StatusReport")) != null) {
                FeasibilityReport report = this.commonReader.readFeasibilityReport(dom, reportElt);
                response.setReport(report);
            }
            return response;
        }
        catch (Exception e) {
            throw new SPSException(e);
        }
    }
}

