/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import org.vast.ogc.OGCRegistry;
import org.vast.ows.OWSException;
import org.vast.ows.sps.FeasibilityReport;
import org.vast.ows.sps.GetFeasibilityResponse;
import org.vast.ows.sps.SPSCommonWriterV20;
import org.vast.ows.sps.SPSException;
import org.vast.ows.swe.SWEResponseWriter;
import org.vast.util.DateTime;
import org.vast.xml.DOMHelper;
import org.vast.xml.XMLWriterException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GetFeasibilityResponseWriterV20
extends SWEResponseWriter<GetFeasibilityResponse> {
    protected SPSCommonWriterV20 commonWriter = new SPSCommonWriterV20();

    @Override
    public Element buildXMLResponse(DOMHelper dom, GetFeasibilityResponse response, String version) throws OWSException {
        try {
            dom.addUserPrefix("sps", OGCRegistry.getNamespaceURI((String)"SPS", (String)version));
            Element rootElt = dom.createElement("sps:" + response.getMessageType());
            this.writeExtensions(dom, rootElt, response);
            DateTime latestResp = response.getLatestResponseTime();
            if (latestResp != null) {
                dom.setElementValue(rootElt, "sps:latestResponseTime", this.timeFormat.formatIso(latestResp.getJulianTime(), 0));
            }
            Element reportElt = this.commonWriter.writeFeasibilityReport(dom, (FeasibilityReport)response.getReport());
            Element resElt = dom.addElement((Node)rootElt, "sps:result");
            resElt.appendChild(reportElt);
            return rootElt;
        }
        catch (XMLWriterException e) {
            throw new SPSException("Error while building feasibilty response", (Exception)((Object)e));
        }
    }
}

