/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import java.util.Map;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.sps.GetStatusRequest;
import org.vast.ows.swe.SWERequestReader;
import org.vast.util.DateTime;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class GetStatusRequestReaderV20
extends SWERequestReader<GetStatusRequest> {
    @Override
    public GetStatusRequest readURLParameters(Map<String, String> queryParameters) throws OWSException {
        GetStatusRequest request = new GetStatusRequest();
        for (Map.Entry<String, String> item : queryParameters.entrySet()) {
            String argName = item.getKey();
            String argValue = item.getValue();
            if (argName.equalsIgnoreCase("service")) {
                request.setService(argValue);
                continue;
            }
            if (argName.equalsIgnoreCase("version")) {
                request.setVersion(argValue);
                continue;
            }
            if (argName.equalsIgnoreCase("request")) {
                request.setOperation(argValue);
                continue;
            }
            if (argName.equalsIgnoreCase("taskID")) {
                request.setTaskID(argValue);
                continue;
            }
            if (argName.equalsIgnoreCase("since")) {
                request.setSince(new DateTime(argValue));
                continue;
            }
            this.addKVPExtension(argName, argValue, request);
        }
        this.checkParameters(request, new OWSExceptionReport());
        return request;
    }

    @Override
    public GetStatusRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        GetStatusRequest request = new GetStatusRequest();
        GetStatusRequestReaderV20.readCommonXML(dom, requestElt, request);
        String taskID = dom.getElementValue(requestElt, "task");
        request.setTaskID(taskID);
        String isoTime = dom.getElementValue(requestElt, "since");
        if (isoTime != null) {
            request.setSince(new DateTime(isoTime));
        }
        this.checkParameters(request, new OWSExceptionReport());
        return request;
    }

    protected void checkParameters(GetStatusRequest request, OWSExceptionReport report) throws OWSException {
        GetStatusRequestReaderV20.checkParameters(request, report, "SPS");
        if (request.getTaskID() == null) {
            report.add(new OWSException("MissingParameterValue", "task"));
        }
        report.process();
    }
}

