/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import org.vast.ogc.OGCRegistry;
import org.vast.ows.OWSException;
import org.vast.ows.sps.GetStatusRequest;
import org.vast.ows.swe.SWERequestWriter;
import org.vast.util.DateTime;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class GetStatusRequestWriterV20
extends SWERequestWriter<GetStatusRequest> {
    @Override
    public String buildURLQuery(GetStatusRequest request) throws OWSException {
        StringBuffer urlBuff = new StringBuffer(request.getGetServer());
        urlBuff.append("service=SPS");
        urlBuff.append("&version=" + request.getVersion());
        urlBuff.append("&request=" + request.getOperation());
        urlBuff.append("&taskID=" + request.getTaskID());
        DateTime since = request.getSince();
        if (since != null) {
            urlBuff.append("&since=" + since.formatIso(0));
        }
        String url = urlBuff.toString();
        url = url.replaceAll(" ", "%20");
        return url;
    }

    @Override
    public Element buildXMLQuery(DOMHelper dom, GetStatusRequest request) throws OWSException {
        dom.addUserPrefix("sps", OGCRegistry.getNamespaceURI((String)"SPS", (String)request.getVersion()));
        Element rootElt = dom.createElement("sps:" + request.getOperation());
        this.addCommonXML(dom, rootElt, request);
        dom.setElementValue(rootElt, "sps:task", request.getTaskID());
        DateTime since = request.getSince();
        if (since != null) {
            dom.setElementValue(rootElt, "sps:since", since.formatIso(0));
        }
        return rootElt;
    }
}

