/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import java.text.ParseException;
import java.util.Map;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.sps.ReserveRequest;
import org.vast.ows.sps.SPSException;
import org.vast.ows.sps.TaskingRequestReaderV20;
import org.vast.util.DateTime;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class ReserveRequestReaderV20
extends TaskingRequestReaderV20<ReserveRequest> {
    @Override
    public ReserveRequest readURLParameters(Map<String, String> queryParameters) throws OWSException {
        throw new SPSException("KVP request not supported in SPS 2.0 Reserve");
    }

    @Override
    public ReserveRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        ReserveRequest request = new ReserveRequest();
        this.readTaskingRequestXML(dom, requestElt, request);
        try {
            String isoDate = dom.getElementValue(requestElt, "reservationExpiration");
            if (isoDate != null) {
                DateTime expirationDate = new DateTime(this.timeFormat.parseIso(isoDate));
                request.setReservationExpiration(expirationDate);
            }
        }
        catch (ParseException e) {
            throw new SPSException("Invalid XML Request: " + e.getMessage());
        }
        this.checkParameters(request, new OWSExceptionReport());
        return request;
    }
}

