/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import org.vast.ows.OWSException;
import org.vast.ows.sps.ReserveRequest;
import org.vast.ows.sps.SPSException;
import org.vast.ows.sps.TaskingRequestWriterV20;
import org.vast.util.DateTime;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class ReserveRequestWriterV20
extends TaskingRequestWriterV20<ReserveRequest> {
    @Override
    public String buildURLQuery(ReserveRequest request) throws OWSException {
        throw new SPSException("KVP request not supported in SPS 2.0 " + request.getOperation());
    }

    @Override
    public Element buildXMLQuery(DOMHelper dom, ReserveRequest request) throws OWSException {
        Element requestElt = super.buildXMLQuery(dom, request);
        DateTime expirationDate = request.getReservationExpiration();
        if (expirationDate != null) {
            String isoTime = this.timeFormat.formatIso(expirationDate.getJulianTime(), 0);
            dom.setElementValue(requestElt, "sps:reservationExpiration", isoTime);
        }
        return requestElt;
    }
}

