/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import java.text.ParseException;
import java.util.Collection;
import net.opengis.gml.v32.AbstractGeometry;
import org.vast.ogc.gml.GMLUtils;
import org.vast.ows.OWSException;
import org.vast.ows.OWSServiceCapabilities;
import org.vast.ows.sps.SPSException;
import org.vast.ows.sps.SPSOfferingCapabilities;
import org.vast.ows.sps.SPSServiceCapabilities;
import org.vast.ows.swe.SWESCapabilitiesReaderV20;
import org.vast.xml.DOMHelper;
import org.vast.xml.XMLReaderException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SPSCapabilitiesReaderV20
extends SWESCapabilitiesReaderV20 {
    GMLUtils gmlUtils = new GMLUtils("3.2");

    @Override
    public SPSServiceCapabilities readXMLResponse(DOMHelper dom, Element capabilitiesElt) throws OWSException {
        SPSServiceCapabilities serviceCaps = new SPSServiceCapabilities();
        this.readOWSCapabilities(dom, capabilitiesElt, serviceCaps);
        return serviceCaps;
    }

    @Override
    protected void readContents(DOMHelper dom, Element capsElt, OWSServiceCapabilities serviceCaps) throws OWSException {
        SPSServiceCapabilities spsCaps = (SPSServiceCapabilities)serviceCaps;
        Element contentsElt = dom.getElement(capsElt, "contents/SPSContents");
        try {
            Collection<String> serviceProcFormats = this.readProcedureFormats(dom, contentsElt, null);
            Collection<String> serviceObsProperties = this.readObservableProperties(dom, contentsElt, null);
            Collection<String> serviceRelFeatures = this.readRelatedFeatures(dom, contentsElt, null);
            NodeList offerings = dom.getElements(contentsElt, "offering/SensorOffering");
            int numOfferings = offerings.getLength();
            for (int i = 0; i < numOfferings; ++i) {
                Element offeringElt = (Element)offerings.item(i);
                SPSOfferingCapabilities offering = new SPSOfferingCapabilities();
                offering.setParent(serviceCaps);
                super.readCommonOfferingProperties(dom, offeringElt, offering, serviceProcFormats, serviceObsProperties, serviceRelFeatures);
                Element geomElt = dom.getElement(offeringElt, "observableArea/*/*");
                if (geomElt != null) {
                    AbstractGeometry geom = this.gmlUtils.readGeometry(dom, geomElt);
                    offering.setObservableArea(geom);
                }
                spsCaps.getLayers().add(offering);
            }
            String val = dom.getElementValue(contentsElt, "minStatusTime");
            if (val != null) {
                spsCaps.setMinStatusTime(this.timeFormat.parseIsoPeriod(val));
            }
            NodeList encodings = dom.getElements(contentsElt, "supportedEncoding");
            for (int i = 0; i < encodings.getLength(); ++i) {
                Element encodingElt = (Element)encodings.item(i);
                spsCaps.getSupportedEncodings().add(dom.getElementValue(encodingElt));
            }
        }
        catch (ParseException | XMLReaderException e) {
            throw new SPSException(e.getMessage());
        }
    }
}

